/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.custom.CustomHarnessManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegisterCustomHarnessPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String harnessId;
    private final String harnessName;
    private final byte[] saddleTextureData;
    private final byte[] glassesTextureData;
    private final byte[] accessoryTextureData;

    public RegisterCustomHarnessPacket(String harnessId, String harnessName, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData) {
        this.harnessId = harnessId;
        this.harnessName = harnessName;
        this.saddleTextureData = saddleTextureData;
        this.glassesTextureData = glassesTextureData;
        this.accessoryTextureData = accessoryTextureData;
    }

    public static void encode(RegisterCustomHarnessPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.harnessId);
        buffer.m_130070_(packet.harnessName);
        RegisterCustomHarnessPacket.writeNullableByteArray(buffer, packet.saddleTextureData);
        RegisterCustomHarnessPacket.writeNullableByteArray(buffer, packet.glassesTextureData);
        RegisterCustomHarnessPacket.writeNullableByteArray(buffer, packet.accessoryTextureData);
    }

    public static RegisterCustomHarnessPacket decode(FriendlyByteBuf buffer) {
        String harnessId = buffer.m_130277_();
        String harnessName = buffer.m_130277_();
        byte[] saddleTextureData = RegisterCustomHarnessPacket.readNullableByteArray(buffer);
        byte[] glassesTextureData = RegisterCustomHarnessPacket.readNullableByteArray(buffer);
        byte[] accessoryTextureData = RegisterCustomHarnessPacket.readNullableByteArray(buffer);
        return new RegisterCustomHarnessPacket(harnessId, harnessName, saddleTextureData, glassesTextureData, accessoryTextureData);
    }

    public static void handle(RegisterCustomHarnessPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (!CustomHarnessManager.isSinglePlayerServer(player.m_20194_())) {
                LOGGER.info("Custom harness registration blocked in multiplayer from player {}", (Object)player.m_7755_().getString());
                player.m_213846_((Component)Component.m_237113_((String)"Custom harness creation is currently only available in single-player mode."));
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                return;
            }
            try {
                boolean success = CustomHarnessManager.registerCustomHarness(packet.harnessId, packet.harnessName, packet.saddleTextureData, packet.glassesTextureData, packet.accessoryTextureData, player);
                if (success) {
                    CustomHarnessManager.giveCustomHarnessToPlayer(packet.harnessId, player);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing custom harness registration from player {}: {}", (Object)player.m_7755_().getString(), (Object)e.getMessage());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void writeNullableByteArray(FriendlyByteBuf buffer, byte[] data) {
        if (data == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130087_(data);
        }
    }

    private static byte[] readNullableByteArray(FriendlyByteBuf buffer) {
        boolean hasData = buffer.readBoolean();
        if (hasData) {
            return buffer.m_130052_();
        }
        return null;
    }
}

