/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.network.ClientNetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenHarnessCreatorPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean isSinglePlayer;

    public OpenHarnessCreatorPacket() {
        this.isSinglePlayer = true;
    }

    public OpenHarnessCreatorPacket(boolean isSinglePlayer) {
        this.isSinglePlayer = isSinglePlayer;
    }

    public static void encode(OpenHarnessCreatorPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.isSinglePlayer);
    }

    public static OpenHarnessCreatorPacket decode(FriendlyByteBuf buffer) {
        boolean isSinglePlayer = buffer.readBoolean();
        return new OpenHarnessCreatorPacket(isSinglePlayer);
    }

    public static void handle(OpenHarnessCreatorPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    if (packet.isSinglePlayer) {
                        ClientNetworkHandler.openHarnessCreatorGui();
                    } else {
                        LOGGER.info("Custom harness creator is disabled in multiplayer");
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

