/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenGhastInventoryPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int entityId;

    public OpenGhastInventoryPacket(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(OpenGhastInventoryPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entityId);
    }

    public static OpenGhastInventoryPacket decode(FriendlyByteBuf buffer) {
        return new OpenGhastInventoryPacket(buffer.readInt());
    }

    public static void handle(OpenGhastInventoryPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    LOGGER.warn("Received OpenGhastInventoryPacket with null player");
                    return;
                }
                if (player.f_19853_ == null) {
                    LOGGER.warn("Player level is null when processing OpenGhastInventoryPacket");
                    return;
                }
                Entity entity = player.f_19853_.m_6815_(packet.entityId);
                if (entity == null) {
                    LOGGER.warn("Could not find entity with ID {} for player {}", (Object)packet.entityId, (Object)player.m_7755_().getString());
                    return;
                }
                if (!(entity instanceof HappyGhast)) {
                    LOGGER.warn("Entity with ID {} is not a HappyGhast", (Object)packet.entityId);
                    return;
                }
                HappyGhast ghast = (HappyGhast)entity;
                if (!ghast.m_6084_()) {
                    LOGGER.debug("Cannot open inventory for dead ghast");
                    return;
                }
                if (!ghast.m_20363_((Entity)player)) {
                    LOGGER.debug("Player {} is not riding ghast {}", (Object)player.m_7755_().getString(), (Object)packet.entityId);
                    return;
                }
                LOGGER.debug("Opening inventory for ghast {} and player {}", (Object)packet.entityId, (Object)player.m_7755_().getString());
                ghast.getInventoryComponent().openInventory((Player)player);
            }
            catch (Exception e) {
                LOGGER.error("Error processing OpenGhastInventoryPacket: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }
}

