/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.network.ExtendedGhastInteractionPacket;
import dev.nweaver.happyghastmod.network.GhastRotationSyncPacket;
import dev.nweaver.happyghastmod.network.GhastSpeedSyncPacket;
import dev.nweaver.happyghastmod.network.GhastVerticalMovementPacket;
import dev.nweaver.happyghastmod.network.OpenGhastInventoryPacket;
import dev.nweaver.happyghastmod.network.OpenHarnessCreatorPacket;
import dev.nweaver.happyghastmod.network.RegisterCustomHarnessPacket;
import dev.nweaver.happyghastmod.network.SyncCustomHarnessPacket;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)HappyGhastMod.rl("main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int nextId() {
        return packetId++;
    }

    public static void init() {
        LOGGER.info("Initializing network packets");
        CHANNEL.registerMessage(NetworkHandler.nextId(), GhastVerticalMovementPacket.class, GhastVerticalMovementPacket::encode, GhastVerticalMovementPacket::decode, GhastVerticalMovementPacket::handle);
        CHANNEL.registerMessage(NetworkHandler.nextId(), OpenGhastInventoryPacket.class, OpenGhastInventoryPacket::encode, OpenGhastInventoryPacket::decode, OpenGhastInventoryPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(NetworkHandler.nextId(), SyncCustomHarnessPacket.class, SyncCustomHarnessPacket::encode, SyncCustomHarnessPacket::decode, SyncCustomHarnessPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(NetworkHandler.nextId(), RegisterCustomHarnessPacket.class, RegisterCustomHarnessPacket::encode, RegisterCustomHarnessPacket::decode, RegisterCustomHarnessPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(NetworkHandler.nextId(), OpenHarnessCreatorPacket.class, OpenHarnessCreatorPacket::encode, OpenHarnessCreatorPacket::decode, OpenHarnessCreatorPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(NetworkHandler.nextId(), GhastRotationSyncPacket.class, GhastRotationSyncPacket::encode, GhastRotationSyncPacket::decode, GhastRotationSyncPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(NetworkHandler.nextId(), GhastSpeedSyncPacket.class, GhastSpeedSyncPacket::encode, GhastSpeedSyncPacket::decode, GhastSpeedSyncPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(NetworkHandler.nextId(), ExtendedGhastInteractionPacket.class, ExtendedGhastInteractionPacket::encode, ExtendedGhastInteractionPacket::decode, ExtendedGhastInteractionPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            NetworkHandler.registerClientPacketHandlers();
        }
    }

    private static void registerClientPacketHandlers() {
        LOGGER.info("Registering client-side packet handlers");
    }

    public static void sendToServer(Object packet) {
        CHANNEL.sendToServer(packet);
    }

    public static void sendToPlayer(Object packet, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static void sendToAll(Object packet) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), packet);
    }
}

