/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class GhastVerticalMovementPacket {
    private final boolean isAscending;
    private final boolean isDescending;

    public GhastVerticalMovementPacket(boolean isAscending, boolean isDescending) {
        this.isAscending = isAscending;
        this.isDescending = isDescending;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isAscending);
        buffer.writeBoolean(this.isDescending);
    }

    public static GhastVerticalMovementPacket decode(FriendlyByteBuf buffer) {
        return new GhastVerticalMovementPacket(buffer.readBoolean(), buffer.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity vehicle;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (vehicle = player.m_20202_()) instanceof HappyGhast) {
                HappyGhast happyGhast = (HappyGhast)vehicle;
                happyGhast.setAscending(this.isAscending);
                happyGhast.setDescending(this.isDescending);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

