/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastMovementComponent;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastSpeedSyncPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final float speedMultiplier;

    public GhastSpeedSyncPacket(float speedMultiplier) {
        this.speedMultiplier = speedMultiplier;
    }

    public static void encode(GhastSpeedSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.writeFloat(packet.speedMultiplier);
    }

    public static GhastSpeedSyncPacket decode(FriendlyByteBuf buffer) {
        return new GhastSpeedSyncPacket(buffer.readFloat());
    }

    public static void handle(GhastSpeedSyncPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            GhastMovementComponent.SPEED_MULTIPLIER = packet.speedMultiplier;
            if (Minecraft.m_91087_().f_91073_ != null) {
                for (Entity entity : Minecraft.m_91087_().f_91073_.m_104735_()) {
                    if (!(entity instanceof HappyGhast)) continue;
                    HappyGhast happyGhast = (HappyGhast)entity;
                    happyGhast.setSpeedMultiplier(packet.speedMultiplier);
                }
            }
            LOGGER.info("Updated speed multiplier to: {}", (Object)Float.valueOf(packet.speedMultiplier));
        });
        context.setPacketHandled(true);
    }
}

