/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastRotationSyncPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int entityId;
    private final float yRot;
    private final float xRot;
    private final float yBodyRot;
    private final float yHeadRot;

    public GhastRotationSyncPacket(int entityId, float yRot, float xRot, float yBodyRot, float yHeadRot) {
        this.entityId = entityId;
        this.yRot = yRot;
        this.xRot = xRot;
        this.yBodyRot = yBodyRot;
        this.yHeadRot = yHeadRot;
    }

    public static void encode(GhastRotationSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entityId);
        buffer.writeFloat(packet.yRot);
        buffer.writeFloat(packet.xRot);
        buffer.writeFloat(packet.yBodyRot);
        buffer.writeFloat(packet.yHeadRot);
    }

    public static GhastRotationSyncPacket decode(FriendlyByteBuf buffer) {
        return new GhastRotationSyncPacket(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public static void handle(GhastRotationSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                GhastRotationSyncPacket.handleOnClient(packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handleOnClient(GhastRotationSyncPacket packet) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        Entity entity = minecraft.f_91073_.m_6815_(packet.entityId);
        if (!(entity instanceof HappyGhast)) {
            return;
        }
        HappyGhast ghast = (HappyGhast)entity;
        boolean isDriver = false;
        if (minecraft.f_91074_ != null && minecraft.f_91074_.m_20202_() == ghast) {
            int passengerIndex = ghast.m_20197_().indexOf(minecraft.f_91074_);
            boolean bl = isDriver = passengerIndex == 0;
        }
        if (isDriver) {
            return;
        }
        ghast.setTargetServerRotation(packet.yRot, packet.xRot, packet.yBodyRot, packet.yHeadRot);
    }
}

