/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class GhastPlatformStateMessage {
    private final int entityId;
    private final boolean isStationaryPlatform;

    public GhastPlatformStateMessage(int entityId, boolean isStationaryPlatform) {
        this.entityId = entityId;
        this.isStationaryPlatform = isStationaryPlatform;
    }

    public static void encode(GhastPlatformStateMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.writeBoolean(message.isStationaryPlatform);
    }

    public static GhastPlatformStateMessage decode(FriendlyByteBuf buffer) {
        return new GhastPlatformStateMessage(buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(GhastPlatformStateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity = context.getSender().f_19853_.m_6815_(message.entityId);
            if (entity instanceof HappyGhast) {
                HappyGhast happyGhast = (HappyGhast)entity;
                if (message.isStationaryPlatform) {
                    happyGhast.m_20334_(0.0, 0.0, 0.0);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

