/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.events.ExtendedGhastInteractionHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ExtendedGhastInteractionPacket {
    private final int entityId;

    public ExtendedGhastInteractionPacket(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(ExtendedGhastInteractionPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entityId);
    }

    public static ExtendedGhastInteractionPacket decode(FriendlyByteBuf buffer) {
        return new ExtendedGhastInteractionPacket(buffer.readInt());
    }

    public static void handle(ExtendedGhastInteractionPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerLevel level;
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = (level = player.m_9236_()).m_6815_(packet.entityId)) != null) {
                ExtendedGhastInteractionHandler.handleExtendedInteraction((Player)player, entity);
            }
        });
        context.setPacketHandled(true);
    }
}

