/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.item;

import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import dev.nweaver.happyghastmod.item.HarnessItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomHarnessItem
extends HarnessItem {
    private static final Logger LOGGER = LogManager.getLogger();

    public CustomHarnessItem(Item.Properties properties, String color) {
        super(properties, color);
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("CustomHarnessId")) {
            String customName = stack.m_41783_().m_128461_("CustomHarnessName");
            return Component.m_237113_((String)customName);
        }
        return super.m_7626_(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("CustomHarnessId")) {
            ClientCustomHarnessManager.HarnessInfo info;
            String harnessId = stack.m_41783_().m_128461_("CustomHarnessId");
            if (level != null && level.f_46443_ && (info = ClientCustomHarnessManager.getCustomHarnessInfo(harnessId)) != null) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.happyghastmod.custom_harness_creator", (Object[])new Object[]{info.getCreatorName()}));
            }
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.happyghastmod.harness"));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public static String getCustomHarnessId(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("CustomHarnessId")) {
            return stack.m_41783_().m_128461_("CustomHarnessId");
        }
        return null;
    }

    public static boolean isCustomHarness(ItemStack stack) {
        return CustomHarnessItem.getCustomHarnessId(stack) != null;
    }

    @Override
    public String getColor() {
        return super.getColor();
    }

    public static String getStackColor(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof HarnessItem) {
            HarnessItem harnessItem = (HarnessItem)item;
            if (CustomHarnessItem.isCustomHarness(stack)) {
                return "custom";
            }
            return harnessItem.getColor();
        }
        return "blue";
    }
}

