/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.events;

import dev.nweaver.happyghastmod.client.ClientGhastInventoryHandler;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.network.GhastVerticalMovementPacket;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="happyghastmod", value={Dist.CLIENT})
public class KeyHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final KeyMapping DESCEND_KEY = new KeyMapping("key.happyghastmod.descend", 67, "key.categories.happyghastmod");
    public static final KeyMapping ASCEND_KEY = new KeyMapping("key.happyghastmod.ascend", 32, "key.categories.happyghastmod");
    private static boolean wasInventoryKeyDown = false;
    private static long lastGhastInventoryTime = 0L;
    private static final long INVENTORY_COOLDOWN = 200L;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        Entity vehicle = mc.f_91074_.m_20202_();
        if (vehicle == null) {
            wasInventoryKeyDown = false;
            return;
        }
        boolean isAscending = ASCEND_KEY.m_90857_();
        boolean isDescending = DESCEND_KEY.m_90857_();
        NetworkHandler.sendToServer(new GhastVerticalMovementPacket(isAscending, isDescending));
        if (mc.f_91066_.f_92092_.m_90857_() && !wasInventoryKeyDown && vehicle instanceof HappyGhast) {
            HappyGhast ghast = (HappyGhast)vehicle;
            LOGGER.debug("Detecting inventory key press for ghast");
            ClientGhastInventoryHandler.handleClientKeyInput((Entity)ghast);
            lastGhastInventoryTime = System.currentTimeMillis();
        }
        wasInventoryKeyDown = mc.f_91066_.f_92092_.m_90857_();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastGhastInventoryTime < 200L && mc.f_91080_ instanceof InventoryScreen && mc.f_91074_.m_20202_() instanceof HappyGhast) {
            mc.m_91152_(null);
        }
    }
}

