/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.events;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.network.ExtendedGhastInteractionPacket;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="happyghastmod")
public class ExtendedGhastInteractionHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double EXTENDED_INTERACTION_DISTANCE = 10.0;

    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        Player player = event.getEntity();
        if (player.f_19853_.m_5776_()) {
            Vec3 eyePosition = player.m_146892_();
            Vec3 lookVector = player.m_20252_(1.0f);
            Vec3 reachVector = eyePosition.m_82520_(lookVector.f_82479_ * 10.0, lookVector.f_82480_ * 10.0, lookVector.f_82481_ * 10.0);
            AABB searchBox = new AABB(Math.min(eyePosition.f_82479_, reachVector.f_82479_) - 1.0, Math.min(eyePosition.f_82480_, reachVector.f_82480_) - 1.0, Math.min(eyePosition.f_82481_, reachVector.f_82481_) - 1.0, Math.max(eyePosition.f_82479_, reachVector.f_82479_) + 1.0, Math.max(eyePosition.f_82480_, reachVector.f_82480_) + 1.0, Math.max(eyePosition.f_82481_, reachVector.f_82481_) + 1.0);
            player.f_19853_.m_6443_(HappyGhast.class, searchBox, entity -> {
                double distSq = entity.m_20238_(eyePosition);
                if (distSq > 100.0) {
                    return false;
                }
                AABB entityBox = entity.m_20191_().m_82400_(0.5);
                Vec3 entityCenter = entityBox.m_82399_();
                Vec3 toEntity = entityCenter.m_82546_(eyePosition);
                double length = toEntity.m_82553_();
                double dot = (toEntity = toEntity.m_82541_()).m_82526_(lookVector);
                return dot > 0.95;
            }).stream().min((e1, e2) -> Double.compare(e1.m_20238_(eyePosition), e2.m_20238_(eyePosition))).ifPresent(ghast -> NetworkHandler.sendToServer(new ExtendedGhastInteractionPacket(ghast.m_19879_())));
        }
    }

    public static void handleExtendedInteraction(Player player, Entity entity) {
        if (entity instanceof HappyGhast) {
            InteractionResult result;
            HappyGhast ghast = (HappyGhast)entity;
            double distanceSq = player.m_20280_(entity);
            if (distanceSq <= 100.0 && (result = ghast.m_6071_(player, InteractionHand.MAIN_HAND)) == InteractionResult.SUCCESS) {
                LOGGER.debug("Extended interaction successful with ghast {} at distance {}", (Object)ghast.m_19879_(), (Object)Math.sqrt(distanceSq));
            }
        }
    }
}

