/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class HappyGhastLookGoal
extends Goal {
    private final HappyGhast ghast;
    private float currentYRot;
    private float targetYRot;
    private Vec3 smoothedDirection = null;
    private static final double DIR_SMOOTHING_LEASHED = 0.05;
    private int rotationHoldTimer = 0;
    private static final int MIN_ROTATION_HOLD_TICKS = 10;
    private static final double MIN_VELOCITY_FOR_ROTATION = 0.02;
    private static final float MAX_ROTATION_SPEED_LEASHED = 1.5f;
    private static final float MAX_ROTATION_SPEED_NORMAL = 6.0f;
    private static final float MIN_ROTATION_DIFF_THRESHOLD = 1.0E-4f;

    public HappyGhastLookGoal(HappyGhast ghast) {
        this.ghast = ghast;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        this.currentYRot = ghast.m_146908_();
        this.targetYRot = ghast.m_146908_();
    }

    public boolean m_8036_() {
        return !this.ghast.m_20160_() && (this.ghast.getPlatformComponent() == null || !this.ghast.getPlatformComponent().isActive());
    }

    public boolean m_8045_() {
        return !this.ghast.m_20160_() && (this.ghast.getPlatformComponent() == null || !this.ghast.getPlatformComponent().isActive());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean isLeashed = this.ghast.m_21523_();
        Entity leashHolder = null;
        if (isLeashed) {
            leashHolder = this.ghast.m_21524_();
        }
        if (isLeashed && leashHolder != null) {
            this.tickLeashed(leashHolder);
        } else {
            this.tickNormal();
            this.smoothedDirection = null;
            this.rotationHoldTimer = 0;
        }
        this.ghast.m_146922_(this.currentYRot);
        this.ghast.f_20883_ = this.currentYRot;
    }

    private void tickNormal() {
        float rotationDiff;
        Vec3 delta = this.ghast.m_20184_();
        if (delta.m_165925_() > 1.0E-6) {
            this.targetYRot = -((float)Mth.m_14136_((double)delta.f_82479_, (double)delta.f_82481_)) * 57.295776f;
        }
        if (Math.abs(rotationDiff = Mth.m_14177_((float)(this.targetYRot - this.currentYRot))) < 1.0E-4f) {
            this.currentYRot = this.targetYRot;
        } else {
            float rotationStep = Mth.m_14036_((float)rotationDiff, (float)-6.0f, (float)6.0f);
            this.currentYRot = Mth.m_14177_((float)(this.currentYRot + rotationStep));
        }
    }

    private void tickLeashed(Entity leashHolder) {
        boolean shouldUpdateDirection;
        Vec3 motionVector = this.ghast.m_20184_();
        double horizontalSpeed = motionVector.m_165924_();
        boolean bl = shouldUpdateDirection = horizontalSpeed > 0.02 || this.rotationHoldTimer <= 0;
        if (shouldUpdateDirection) {
            this.rotationHoldTimer = 10;
            Vec3 toLeashHolder = leashHolder.m_20182_().m_82546_(this.ghast.m_20182_());
            Vec3 directionVector = horizontalSpeed > 0.01 ? motionVector.m_82541_().m_82490_(0.7).m_82549_(toLeashHolder.m_82541_().m_82490_(0.3)) : toLeashHolder;
            if (directionVector.m_165925_() > 1.0E-6) {
                directionVector = directionVector.m_82541_();
                this.smoothedDirection = this.smoothedDirection == null ? directionVector : this.smoothedDirection.m_82490_(0.95).m_82549_(directionVector.m_82490_(0.05)).m_82541_();
                float newTargetYRot = -((float)Mth.m_14136_((double)this.smoothedDirection.f_82479_, (double)this.smoothedDirection.f_82481_)) * 57.295776f;
                float rotDiff = Mth.m_14177_((float)(newTargetYRot - this.targetYRot));
                if (Math.abs(rotDiff) > 5.0f) {
                    this.targetYRot = newTargetYRot;
                }
            }
        } else {
            --this.rotationHoldTimer;
        }
        float rotationDiff = Mth.m_14177_((float)(this.targetYRot - this.currentYRot));
        if (Math.abs(rotationDiff) < 1.0E-4f) {
            this.currentYRot = this.targetYRot;
        } else {
            float rotationStep = Mth.m_14036_((float)rotationDiff, (float)-1.5f, (float)1.5f);
            this.currentYRot = Mth.m_14177_((float)(this.currentYRot + rotationStep));
        }
    }
}

