/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HappyGhastFollowPlayerWithItemGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Ghast ghast;
    private Player player;
    private final double speedModifier;
    private final float startDistance;
    private double smoothedTargetY = Double.NaN;
    private static final double VERTICAL_SMOOTHING = 0.08;
    private int verticalPositionMode = 0;
    private int positionChangeTimer = 0;
    private static final int POSITION_CHANGE_INTERVAL = 200;
    private static final float MIN_VERTICAL_OFFSET = 3.0f;
    private static final float[] VERTICAL_OFFSETS = new float[]{5.0f, 0.0f, -4.0f};
    private boolean forcePositionChange = true;
    private boolean wasHoldingItem = false;

    public HappyGhastFollowPlayerWithItemGoal(Ghast ghast, double speedModifier, float startDistance) {
        this.ghast = ghast;
        this.speedModifier = speedModifier;
        this.startDistance = startDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        boolean shouldFollow;
        this.player = this.ghast.f_19853_.m_45930_((Entity)this.ghast, (double)(this.startDistance * 3.0f));
        if (this.player == null) {
            if (this.wasHoldingItem) {
                this.wasHoldingItem = false;
                AnchorManager.stopFollowing((Entity)this.ghast);
            }
            return false;
        }
        boolean holdingFollowItem = this.isHoldingFollowItem(this.player);
        if (holdingFollowItem && !this.wasHoldingItem) {
            AnchorManager.markAsFollowing((Entity)this.ghast);
            AnchorManager.updateLastPlayerPosition((Entity)this.ghast, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
        } else if (!holdingFollowItem && this.wasHoldingItem) {
            AnchorManager.stopFollowing((Entity)this.ghast);
        }
        this.wasHoldingItem = holdingFollowItem;
        boolean bl = shouldFollow = holdingFollowItem && this.ghast.m_20280_((Entity)this.player) > 16.0;
        if (holdingFollowItem && !shouldFollow && AnchorManager.hasAnchor((Entity)this.ghast)) {
            AnchorManager.updateLastPlayerPosition((Entity)this.ghast, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
            double distanceSq = this.ghast.m_20280_((Entity)this.player);
            if (distanceSq > 256.0 && AnchorManager.canUpdateAnchor((Entity)this.ghast)) {
                AnchorManager.createTemporaryAnchor((Entity)this.ghast, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
            }
        }
        return shouldFollow;
    }

    public boolean m_8045_() {
        return this.isHoldingFollowItem(this.player) && this.ghast.m_20280_((Entity)this.player) > 16.0 && this.player.m_6084_();
    }

    public void m_8041_() {
        this.player = null;
        if (this.wasHoldingItem) {
            this.wasHoldingItem = false;
            AnchorManager.stopFollowing((Entity)this.ghast);
        }
        this.smoothedTargetY = Double.NaN;
    }

    private boolean isHoldingFollowItem(Player player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return this.isSnowballOrHarness(mainHand) || this.isSnowballOrHarness(offHand);
    }

    private boolean isSnowballOrHarness(ItemStack stack) {
        if (stack.m_150930_(Items.f_42452_)) {
            return true;
        }
        String itemId = stack.m_41720_().toString().toLowerCase();
        boolean isHarness = itemId.contains("harness") || stack.m_41782_() && stack.m_41783_().m_128441_("HarnessColor");
        return isHarness;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double heightDiff;
        double minHeight;
        double targetY;
        boolean currentlyHoldingItem = this.isHoldingFollowItem(this.player);
        if (!currentlyHoldingItem && this.wasHoldingItem) {
            this.wasHoldingItem = false;
            AnchorManager.stopFollowing((Entity)this.ghast);
            return;
        }
        this.wasHoldingItem = currentlyHoldingItem;
        if (currentlyHoldingItem) {
            AnchorManager.markAsFollowing((Entity)this.ghast);
            AnchorManager.updateLastPlayerPosition((Entity)this.ghast, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
        }
        double dx = this.player.m_20185_() - this.ghast.m_20185_();
        double dz = this.player.m_20189_() - this.ghast.m_20189_();
        this.ghast.m_146922_(-((float)Mth.m_14136_((double)dx, (double)dz)) * 57.295776f);
        this.ghast.f_20883_ = this.ghast.m_146908_();
        ++this.positionChangeTimer;
        if (this.positionChangeTimer >= 200 || this.forcePositionChange) {
            int newMode;
            while ((newMode = this.ghast.m_217043_().m_188503_(3)) == this.verticalPositionMode && !this.forcePositionChange) {
            }
            this.verticalPositionMode = newMode;
            this.positionChangeTimer = 0;
            this.forcePositionChange = false;
            String[] positionNames = new String[]{"\u0421\u0412\u0415\u0420\u0425\u0423", "\u041d\u0410 \u0423\u0420\u041e\u0412\u041d\u0415", "\u0421\u041d\u0418\u0417\u0423"};
            LOGGER.debug("Ghast position changed to: {}", (Object)positionNames[this.verticalPositionMode]);
            this.smoothedTargetY = Double.NaN;
        }
        if ((targetY = this.player.m_20186_() + (double)VERTICAL_OFFSETS[this.verticalPositionMode]) < (minHeight = (double)(this.ghast.f_19853_.m_5736_() + 4))) {
            targetY = minHeight;
        }
        if (Double.isNaN(this.smoothedTargetY)) {
            this.smoothedTargetY = this.ghast.m_20186_();
        }
        double verticalSpeed = (heightDiff = Math.abs(targetY - this.ghast.m_20186_())) > 10.0 ? 0.2 : (heightDiff > 5.0 ? 0.1 : 0.05);
        this.smoothedTargetY += (targetY - this.smoothedTargetY) * verticalSpeed;
        double idealHeight = this.smoothedTargetY;
        if (this.ghast.m_20280_((Entity)this.player) > 64.0) {
            double offsetX = this.player.m_20185_() + (double)(this.ghast.m_217043_().m_188501_() * 8.0f - 4.0f);
            double offsetY = idealHeight;
            double offsetZ = this.player.m_20189_() + (double)(this.ghast.m_217043_().m_188501_() * 8.0f - 4.0f);
            boolean canMove = true;
            if (!currentlyHoldingItem) {
                canMove = AnchorManager.isWithinAllowedRadius((Entity)this.ghast, offsetX, offsetY, offsetZ);
            }
            if (canMove) {
                this.ghast.m_21566_().m_6849_(offsetX, offsetY, offsetZ, this.speedModifier);
            } else if (AnchorManager.hasAnchor((Entity)this.ghast)) {
                Vec3 anchor = AnchorManager.getAnchor((Entity)this.ghast);
                double maxRadius = AnchorManager.getMaxRadius((Entity)this.ghast);
                Vec3 dirToPlayer = new Vec3(this.player.m_20185_() - anchor.f_82479_, 0.0, this.player.m_20189_() - anchor.f_82481_).m_82541_();
                double newX = anchor.f_82479_ + dirToPlayer.f_82479_ * maxRadius * 0.8;
                double newZ = anchor.f_82481_ + dirToPlayer.f_82481_ * maxRadius * 0.8;
                this.ghast.m_21566_().m_6849_(newX, offsetY, newZ, this.speedModifier);
            }
        } else {
            double dist = Math.sqrt(this.ghast.m_20280_((Entity)this.player));
            if (dist < 10.0) {
                Vec3 moveAwayVec = new Vec3(this.ghast.m_20185_() - this.player.m_20185_(), 0.0, this.ghast.m_20189_() - this.player.m_20189_()).m_82541_();
                double newX = this.ghast.m_20185_() + moveAwayVec.f_82479_ * 2.0;
                double newY = idealHeight;
                double newZ = this.ghast.m_20189_() + moveAwayVec.f_82481_ * 2.0;
                boolean canMove = true;
                if (!currentlyHoldingItem) {
                    canMove = AnchorManager.isWithinAllowedRadius((Entity)this.ghast, newX, newY, newZ);
                }
                if (canMove) {
                    this.ghast.m_21566_().m_6849_(newX, newY, newZ, 1.0);
                }
            } else {
                this.ghast.m_21566_().m_6849_(this.ghast.m_20185_(), idealHeight, this.ghast.m_20189_(), 0.5);
            }
        }
    }
}

