/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.Ghastling;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastlingRandomFloatGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Ghastling ghastling;

    public GhastlingRandomFloatGoal(Ghastling ghastling) {
        this.ghastling = ghastling;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        double d2;
        double d1;
        if (AnchorManager.isFollowing((Entity)this.ghastling)) {
            return false;
        }
        MoveControl movecontrol = this.ghastling.m_21566_();
        if (!movecontrol.m_24995_()) {
            return true;
        }
        double d0 = movecontrol.m_25000_() - this.ghastling.m_20185_();
        double d3 = d0 * d0 + (d1 = movecontrol.m_25001_() - this.ghastling.m_20186_()) * d1 + (d2 = movecontrol.m_25002_() - this.ghastling.m_20189_()) * d2;
        return d3 < 1.0 || d3 > 3600.0;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        RandomSource randomsource = this.ghastling.m_217043_();
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        boolean validPointFound = false;
        for (int attempt = 0; attempt < 5 && !validPointFound; ++attempt) {
            if (this.ghastling.m_21523_()) {
                d0 = this.ghastling.m_20185_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 6.0f);
                d1 = this.ghastling.m_20186_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 4.0f);
                d2 = this.ghastling.m_20189_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 6.0f);
            } else if (AnchorManager.hasAnchor((Entity)this.ghastling)) {
                Vec3 anchor = AnchorManager.getAnchor((Entity)this.ghastling);
                double maxRadius = AnchorManager.getMaxRadius((Entity)this.ghastling);
                double angle = (double)(randomsource.m_188501_() * 2.0f) * Math.PI;
                double horizontalDist = (double)randomsource.m_188501_() * maxRadius * 0.8;
                d0 = anchor.f_82479_ + horizontalDist * Math.cos(angle);
                int groundY = this.findGroundHeight(d0, d2 = anchor.f_82481_ + horizontalDist * Math.sin(angle));
                d1 = groundY != -1 ? (double)((float)(groundY + 1) + randomsource.m_188501_() * 1.0f) : anchor.f_82480_ + (-2.0 + (double)randomsource.m_188501_() * 4.0);
            } else {
                d0 = this.ghastling.m_20185_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 8.0f);
                d1 = this.ghastling.m_20186_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 3.0f);
                d2 = this.ghastling.m_20189_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 8.0f);
            }
            BlockPos targetPos = new BlockPos(Mth.m_14107_((double)d0), Mth.m_14107_((double)d1), Mth.m_14107_((double)d2));
            FluidState fluidState = this.ghastling.f_19853_.m_6425_(targetPos);
            if (!fluidState.m_76178_() && fluidState.m_205070_(FluidTags.f_13131_)) continue;
            boolean waterBelow = false;
            for (int y = Mth.m_14107_((double)d1) - 1; y > Mth.m_14107_((double)d1) - 3 && y > 0; --y) {
                BlockPos belowPos = new BlockPos(Mth.m_14107_((double)d0), y, Mth.m_14107_((double)d2));
                FluidState belowFluid = this.ghastling.f_19853_.m_6425_(belowPos);
                if (!belowFluid.m_76178_() && belowFluid.m_205070_(FluidTags.f_13131_)) {
                    waterBelow = true;
                    break;
                }
                if (!this.ghastling.f_19853_.m_8055_(belowPos).m_60795_()) break;
            }
            if (waterBelow) {
                d1 += 2.0;
            }
            validPointFound = true;
        }
        if (d1 < (double)(this.ghastling.f_19853_.m_5736_() + 2)) {
            d1 = this.ghastling.f_19853_.m_5736_() + 2 + randomsource.m_188503_(2);
        }
        this.ghastling.m_21566_().m_6849_(d0, d1, d2, 1.0);
    }

    private int findGroundHeight(double x, double z) {
        Level level = this.ghastling.f_19853_;
        int blockX = Mth.m_14107_((double)x);
        int blockZ = Mth.m_14107_((double)z);
        int startY = Mth.m_14107_((double)this.ghastling.m_20186_()) - 1;
        int minY = Math.max(0, startY - 20);
        for (int y = startY; y >= minY; --y) {
            VoxelShape collisionShape;
            BlockPos blockPos = new BlockPos(blockX, y, blockZ);
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_60795_() || blockState.m_60767_().m_76332_() || (collisionShape = blockState.m_60812_((BlockGetter)level, blockPos)).m_83281_()) continue;
            return y + 1;
        }
        return -1;
    }
}

