/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.Ghastling;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastlingLookGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Ghastling ghastling;
    private float lastYRot = 0.0f;
    private float targetYRot = 0.0f;
    private Vec3 smoothedDirection = null;
    private static final double DIR_SMOOTHING_LEASHED = 0.08;
    private int rotationHoldTimer = 0;
    private static final int MIN_ROTATION_HOLD_TICKS = 8;
    private static final double MIN_VELOCITY_FOR_ROTATION = 0.02;
    private static final float MAX_ROTATION_SPEED_LEASHED = 2.0f;

    public GhastlingLookGoal(Ghastling ghastling) {
        this.ghastling = ghastling;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        this.lastYRot = ghastling.m_146908_();
        this.targetYRot = ghastling.m_146908_();
    }

    public boolean m_8036_() {
        return true;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean isFollowing;
        boolean isLeashed = this.ghastling.m_21523_();
        Entity leashHolder = null;
        if (isLeashed) {
            leashHolder = this.ghastling.m_21524_();
        }
        if (isFollowing = AnchorManager.isFollowing((Entity)this.ghastling)) {
            return;
        }
        if (isLeashed && leashHolder != null) {
            this.tickLeashed(leashHolder);
        } else if (isFollowing) {
            this.lastYRot = this.ghastling.m_146908_();
            this.targetYRot = this.ghastling.m_146908_();
        } else {
            this.tickNormal();
            this.smoothedDirection = null;
            this.rotationHoldTimer = 0;
        }
    }

    private void tickNormal() {
        Vec3 delta = this.ghastling.m_20184_();
        if (delta.m_165925_() > 1.0E-6) {
            this.targetYRot = -((float)Mth.m_14136_((double)delta.f_82479_, (double)delta.f_82481_)) * 57.295776f;
        }
        float rotationDiff = Mth.m_14177_((float)(this.targetYRot - this.lastYRot));
        float rotationStep = Mth.m_14036_((float)rotationDiff, (float)-10.0f, (float)10.0f);
        this.lastYRot = Mth.m_14177_((float)(this.lastYRot + rotationStep));
        this.ghastling.m_146922_(this.lastYRot);
        this.ghastling.f_20883_ = this.ghastling.m_146908_();
    }

    private void tickLeashed(Entity leashHolder) {
        boolean shouldUpdateDirection;
        Vec3 motionVector = this.ghastling.m_20184_();
        double horizontalSpeed = motionVector.m_165924_();
        boolean bl = shouldUpdateDirection = horizontalSpeed > 0.02 || this.rotationHoldTimer <= 0;
        if (shouldUpdateDirection) {
            this.rotationHoldTimer = 8;
            Vec3 toLeashHolder = leashHolder.m_20182_().m_82546_(this.ghastling.m_20182_());
            Vec3 directionVector = horizontalSpeed > 0.01 ? motionVector.m_82541_().m_82490_(0.7).m_82549_(toLeashHolder.m_82541_().m_82490_(0.3)) : toLeashHolder;
            if (directionVector.m_165925_() > 1.0E-6) {
                directionVector = directionVector.m_82541_();
                this.smoothedDirection = this.smoothedDirection == null ? directionVector : this.smoothedDirection.m_82490_(0.92).m_82549_(directionVector.m_82490_(0.08)).m_82541_();
                this.targetYRot = -((float)Mth.m_14136_((double)this.smoothedDirection.f_82479_, (double)this.smoothedDirection.f_82481_)) * 57.295776f;
            }
        } else {
            --this.rotationHoldTimer;
        }
        float rotationDiff = Mth.m_14177_((float)(this.targetYRot - this.lastYRot));
        float rotationStep = Mth.m_14036_((float)rotationDiff, (float)-2.0f, (float)2.0f);
        this.lastYRot = Mth.m_14177_((float)(this.lastYRot + rotationStep));
        this.ghastling.m_146922_(this.lastYRot);
        this.ghastling.f_20883_ = this.ghastling.m_146908_();
    }
}

