/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.goals.GhastlingLookGoal;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastlingFollowPlayerWithSnowballGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Ghast ghastling;
    private Player player;
    private final double speedModifier;
    private final float startDistance;
    private double smoothedTargetY = Double.NaN;
    private static final double VERTICAL_SMOOTHING = 0.1;
    private boolean wasHoldingSnowball = false;
    private static final double HEIGHT_ABOVE_PLAYER = 1.5;
    private static final int POSITION_CHANGE_INTERVAL = 100;
    private int positionChangeTimer = 0;
    private int verticalPositionMode = 0;
    private static final float[] VERTICAL_OFFSETS = new float[]{2.0f, 0.5f};

    public GhastlingFollowPlayerWithSnowballGoal(Ghast ghastling, double speedModifier, float startDistance) {
        this.ghastling = ghastling;
        this.speedModifier = speedModifier;
        this.startDistance = startDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        boolean shouldFollow;
        this.player = this.ghastling.f_19853_.m_45930_((Entity)this.ghastling, (double)(this.startDistance * 3.0f));
        if (this.player == null) {
            if (this.wasHoldingSnowball) {
                this.wasHoldingSnowball = false;
                AnchorManager.stopFollowing((Entity)this.ghastling);
                LOGGER.debug("Ghastling stopped following - player not found");
            }
            return false;
        }
        boolean holdingSnowball = this.isHoldingSnowball(this.player);
        if (holdingSnowball && !this.wasHoldingSnowball) {
            AnchorManager.markAsFollowing((Entity)this.ghastling);
            AnchorManager.updateLastPlayerPosition((Entity)this.ghastling, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
            LOGGER.debug("Ghastling started following - player took out snowball");
        } else if (!holdingSnowball && this.wasHoldingSnowball) {
            AnchorManager.stopFollowing((Entity)this.ghastling);
            LOGGER.debug("Ghastling stopped following - player put away snowball");
        }
        this.wasHoldingSnowball = holdingSnowball;
        boolean bl = shouldFollow = holdingSnowball && this.ghastling.m_20280_((Entity)this.player) > 9.0;
        if (holdingSnowball && !shouldFollow && AnchorManager.hasAnchor((Entity)this.ghastling)) {
            AnchorManager.updateLastPlayerPosition((Entity)this.ghastling, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
            double distanceSq = this.ghastling.m_20280_((Entity)this.player);
            if (distanceSq > 256.0 && AnchorManager.canUpdateAnchor((Entity)this.ghastling)) {
                AnchorManager.createTemporaryAnchor((Entity)this.ghastling, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
                LOGGER.debug("Created temporary anchor for Ghastling");
            }
        }
        return shouldFollow;
    }

    public boolean m_8045_() {
        return this.isHoldingSnowball(this.player) && this.ghastling.m_20280_((Entity)this.player) > 9.0 && this.player.m_6084_();
    }

    private boolean isHoldingSnowball(Player player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_150930_(Items.f_42452_) || offHand.m_150930_(Items.f_42452_);
    }

    public void m_8041_() {
        this.player = null;
        if (this.wasHoldingSnowball) {
            this.wasHoldingSnowball = false;
            AnchorManager.stopFollowing((Entity)this.ghastling);
            LOGGER.debug("Ghastling stopped following - goal stopped");
        }
        this.smoothedTargetY = Double.NaN;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double heightDiff;
        double minHeight;
        int groundY;
        double targetY;
        boolean currentlyHoldingSnowball = this.isHoldingSnowball(this.player);
        if (!currentlyHoldingSnowball && this.wasHoldingSnowball) {
            this.wasHoldingSnowball = false;
            AnchorManager.stopFollowing((Entity)this.ghastling);
            LOGGER.debug("Ghastling stopped following - player put away snowball during tick");
            return;
        }
        this.wasHoldingSnowball = currentlyHoldingSnowball;
        if (currentlyHoldingSnowball) {
            AnchorManager.markAsFollowing((Entity)this.ghastling);
            AnchorManager.updateLastPlayerPosition((Entity)this.ghastling, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
        }
        double dx = this.player.m_20185_() - this.ghastling.m_20185_();
        double dz = this.player.m_20189_() - this.ghastling.m_20189_();
        float targetYaw = -((float)Mth.m_14136_((double)dx, (double)dz)) * 57.295776f;
        this.ghastling.m_146922_(targetYaw);
        this.ghastling.f_20883_ = this.ghastling.m_146908_();
        if (this.ghastling.f_21345_.m_25386_().anyMatch(goal -> goal.m_26015_() instanceof GhastlingLookGoal)) {
            try {
                for (Goal.Flag flag : Goal.Flag.values()) {
                    this.ghastling.f_21345_.m_25355_(flag);
                }
                this.ghastling.f_21345_.m_25374_(Goal.Flag.MOVE);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to disable goal flags: {}", (Object)e.getMessage());
            }
        }
        ++this.positionChangeTimer;
        if (this.positionChangeTimer >= 100) {
            this.verticalPositionMode = this.ghastling.m_217043_().m_188503_(2);
            this.positionChangeTimer = 0;
            this.smoothedTargetY = Double.NaN;
        }
        if ((targetY = (groundY = this.findGroundHeight(this.player.m_20185_(), this.player.m_20189_())) != -1 ? (double)groundY + 1.0 + (double)this.ghastling.m_217043_().m_188501_() * 1.0 : this.player.m_20186_() + (double)VERTICAL_OFFSETS[this.verticalPositionMode]) < (minHeight = (double)(this.ghastling.f_19853_.m_5736_() + 2))) {
            targetY = minHeight;
        }
        if (Double.isNaN(this.smoothedTargetY)) {
            this.smoothedTargetY = this.ghastling.m_20186_();
        }
        double verticalSpeed = (heightDiff = Math.abs(targetY - this.ghastling.m_20186_())) > 8.0 ? 0.2 : (heightDiff > 4.0 ? 0.1 : 0.05);
        this.smoothedTargetY += (targetY - this.smoothedTargetY) * verticalSpeed;
        if (this.ghastling.m_20280_((Entity)this.player) > 36.0) {
            double offsetX = this.player.m_20185_() + (double)(this.ghastling.m_217043_().m_188501_() * 4.0f - 2.0f);
            double offsetY = this.smoothedTargetY;
            double offsetZ = this.player.m_20189_() + (double)(this.ghastling.m_217043_().m_188501_() * 4.0f - 2.0f);
            this.ghastling.m_21566_().m_6849_(offsetX, offsetY, offsetZ, this.speedModifier);
        } else {
            double dist = Math.sqrt(this.ghastling.m_20280_((Entity)this.player));
            if (dist < 4.0) {
                Vec3 moveAwayVec = new Vec3(this.ghastling.m_20185_() - this.player.m_20185_(), 0.0, this.ghastling.m_20189_() - this.player.m_20189_()).m_82541_();
                this.ghastling.m_21566_().m_6849_(this.ghastling.m_20185_() + moveAwayVec.f_82479_ * 1.5, this.smoothedTargetY, this.ghastling.m_20189_() + moveAwayVec.f_82481_ * 1.5, 0.8);
            } else {
                this.ghastling.m_21566_().m_6849_(this.ghastling.m_20185_(), this.smoothedTargetY, this.ghastling.m_20189_(), 0.4);
            }
        }
    }

    private int findGroundHeight(double x, double z) {
        Level level = this.ghastling.f_19853_;
        int blockX = Mth.m_14107_((double)x);
        int blockZ = Mth.m_14107_((double)z);
        int startY = Mth.m_14107_((double)this.ghastling.m_20186_()) - 1;
        int minY = Math.max(0, startY - 20);
        for (int y = startY; y >= minY; --y) {
            VoxelShape collisionShape;
            BlockPos blockPos = new BlockPos(blockX, y, blockZ);
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_60795_() || blockState.m_60767_().m_76332_() || (collisionShape = blockState.m_60812_((BlockGetter)level, blockPos)).m_83281_()) continue;
            return y + 1;
        }
        return -1;
    }
}

