/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastRidingComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HappyGhast owner;
    private final GhastDataComponent dataComponent;
    private final GhastPlatformComponent platformComponent;
    private static final boolean DEBUG_LOGGING = false;

    public GhastRidingComponent(HappyGhast owner, GhastDataComponent dataComponent, GhastPlatformComponent platformComponent) {
        this.owner = owner;
        this.dataComponent = dataComponent;
        this.platformComponent = platformComponent;
    }

    public boolean canAddPassenger(Entity passenger) {
        boolean hasSaddle = this.dataComponent.isSaddled();
        int maxPassengers = this.owner.getMaxPassengers();
        int currentPassengers = this.owner.m_20197_().size();
        boolean platformActive = this.platformComponent != null && this.platformComponent.isActive();
        boolean canAdd = hasSaddle && currentPassengers < maxPassengers && !platformActive;
        return canAdd;
    }

    public void handlePassengerRemoval(Entity passenger) {
        if (!this.owner.f_19853_.f_46443_ && passenger instanceof Player) {
            Player player = (Player)passenger;
            this.owner.playGogglesUpSound();
            if (!this.platformComponent.isActive()) {
                if (this.owner.m_21523_()) {
                    Entity leashHolder = this.owner.m_21524_();
                    Vec3 playerPos = player.m_20182_();
                    if (leashHolder instanceof LeashFenceKnotEntity) {
                        leashHolder.m_146870_();
                    }
                    this.owner.m_21455_(true, true);
                }
                this.platformComponent.activate();
            }
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        List passengers = this.owner.m_20197_();
        if (passengers.isEmpty()) {
            return null;
        }
        Entity firstPassenger = (Entity)passengers.get(0);
        if (firstPassenger instanceof Player) {
            Player player = (Player)firstPassenger;
            return player;
        }
        if (firstPassenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)firstPassenger;
            return livingEntity;
        }
        return null;
    }

    public void positionRider(Entity passenger, @Nullable Entity.MoveFunction moveFunction) {
        double zOffset;
        double xOffset;
        if (!this.owner.m_20363_(passenger)) {
            return;
        }
        double baseYOffset = 3.8;
        List passengers = this.owner.m_20197_();
        int passengerIndex = passengers.indexOf(passenger);
        float ownerYawRad = -this.owner.m_146908_() * ((float)Math.PI / 180);
        if (passengerIndex == 0) {
            xOffset = 0.0;
            zOffset = 1.6;
        } else if (passengerIndex == 1) {
            xOffset = 1.6;
            zOffset = 0.0;
        } else if (passengerIndex == 2) {
            xOffset = 0.0;
            zOffset = -1.6;
        } else {
            xOffset = -1.6;
            zOffset = 0.0;
        }
        double rotatedX = xOffset * Math.cos(ownerYawRad) + zOffset * Math.sin(ownerYawRad);
        double rotatedZ = zOffset * Math.cos(ownerYawRad) - xOffset * Math.sin(ownerYawRad);
        double finalX = this.owner.m_20185_() + rotatedX;
        double finalY = this.owner.m_20186_() + baseYOffset + passenger.m_6049_();
        double finalZ = this.owner.m_20189_() + rotatedZ;
        if (passengerIndex == 0) {
            finalX += Math.sin(ownerYawRad) * 0.4;
            finalZ += Math.cos(ownerYawRad) * 0.4;
        }
        passenger.m_6034_(finalX, finalY, finalZ);
        if (passengerIndex == 0 && this.owner.f_19853_.f_46443_) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (passenger == minecraft.f_91074_) {
                this.owner.m_146922_(passenger.m_146908_());
                this.owner.m_146926_(passenger.m_146909_() * 0.5f);
                this.owner.f_20883_ = this.owner.m_146908_();
                this.owner.f_20885_ = this.owner.m_146908_();
            } else {
                passenger.m_146922_(this.owner.m_146908_());
                passenger.m_5618_(this.owner.m_146908_());
                if (passenger instanceof LivingEntity) {
                    LivingEntity livingPassenger = (LivingEntity)passenger;
                    livingPassenger.f_20885_ = this.owner.m_146908_();
                }
            }
        } else if (passengerIndex == 0) {
            passenger.m_146922_(this.owner.m_146908_());
            passenger.m_5618_(this.owner.m_146908_());
            if (passenger instanceof LivingEntity) {
                LivingEntity livingPassenger = (LivingEntity)passenger;
                livingPassenger.f_20885_ = this.owner.m_146908_();
            }
        }
    }

    public void handlePassengerTurned(Entity passenger) {
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        double dismountY = this.owner.m_20186_() + 3.65 + 0.5;
        return new Vec3(this.owner.m_20185_(), dismountY, this.owner.m_20189_());
    }
}

