/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.entity.GhastPlatformEntity;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastPlatformComponent {
    public static final double PLATFORM_Y_OFFSET = 3.65;
    private static final double STANDING_CHECK_RADIUS = 2.1;
    private static final double STANDING_CHECK_HEIGHT = 2.0;
    private static final int PLATFORM_GRACE_PERIOD_DURATION = 10;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean DEBUG_LOGGING = false;
    private final HappyGhast owner;
    private final Level level;
    private boolean isPlatformActive = false;
    @Nullable
    private UUID platformUUID = null;
    private int platformGracePeriodTicks = 0;

    public GhastPlatformComponent(HappyGhast owner) {
        this.owner = owner;
        this.level = owner.f_19853_;
    }

    public boolean isActive() {
        return this.isPlatformActive;
    }

    public void tick() {
        if (this.level.f_46443_) {
            return;
        }
        if (!this.isPlatformActive) {
            double checkY = this.owner.m_20186_() + 3.65;
            AABB checkZone = new AABB(this.owner.m_20185_() - 2.1, checkY - 0.1, this.owner.m_20189_() - 2.1, this.owner.m_20185_() + 2.1, checkY + 2.0, this.owner.m_20189_() + 2.1);
            List playersAbove = this.level.m_6443_(Player.class, checkZone, player -> player.m_20202_() != this.owner && player.m_20186_() >= checkY - 0.05);
            if (!playersAbove.isEmpty()) {
                if (this.owner.m_21523_()) {
                    this.owner.m_21455_(true, false);
                }
                this.activate();
                return;
            }
        }
        if (!this.isPlatformActive) {
            if (this.platformUUID != null) {
                this.platformUUID = null;
            }
            this.platformGracePeriodTicks = 0;
            return;
        }
        GhastPlatformEntity platform = this.findPlatformEntity();
        if (platform == null) {
            LOGGER.error("[PlatformComponent] Platform is active, but entity not found! Deactivating. Ghast: {}", (Object)this.owner.m_20148_());
            this.deactivate();
            return;
        }
        platform.m_6034_(this.owner.m_20185_(), this.owner.m_20186_() + 3.65, this.owner.m_20189_());
        platform.m_20256_(Vec3.f_82478_);
        if (this.platformGracePeriodTicks > 0) {
            --this.platformGracePeriodTicks;
        } else if (!this.isAnyoneStandingOnTop()) {
            this.deactivate();
        }
    }

    public void activate() {
        if (this.level.f_46443_ || this.isPlatformActive) {
            return;
        }
        this.isPlatformActive = true;
        this.platformGracePeriodTicks = 10;
        GhastPlatformEntity platform = new GhastPlatformEntity(this.level, this.owner.m_20185_(), this.owner.m_20186_() + 3.65, this.owner.m_20189_(), this.owner);
        if (this.level.m_7967_((Entity)platform)) {
            this.platformUUID = platform.m_20148_();
        } else {
            LOGGER.error("[PlatformComponent] Failed to spawn GhastPlatformEntity! Ghast: {}", (Object)this.owner.m_20148_());
            this.isPlatformActive = false;
            this.platformGracePeriodTicks = 0;
            this.platformUUID = null;
        }
    }

    public void deactivate() {
        if (this.level.f_46443_ || !this.isPlatformActive) {
            return;
        }
        this.isPlatformActive = false;
        this.platformGracePeriodTicks = 0;
        this.removePlatformEntity();
    }

    @Nullable
    private GhastPlatformEntity findPlatformEntity() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.platformUUID != null) {
                Entity entity = serverLevel.m_8791_(this.platformUUID);
                if (entity instanceof GhastPlatformEntity) {
                    GhastPlatformEntity platformEntity = (GhastPlatformEntity)entity;
                    if (platformEntity.getOwnerUUID().isPresent() && platformEntity.getOwnerUUID().get().equals(this.owner.m_20148_())) {
                        return platformEntity;
                    }
                    LOGGER.error("[PlatformComponent] Found GhastPlatformEntity, but owner UUID does not match. Disconnecting platform.");
                    this.platformUUID = null;
                    this.isPlatformActive = false;
                    return null;
                }
                if (entity != null) {
                    LOGGER.error("[PlatformComponent] Found entity with platform UUID, but it's not a GhastPlatformEntity!");
                    this.platformUUID = null;
                    this.isPlatformActive = false;
                    return null;
                }
            }
        }
        if (this.platformUUID != null && !(this.level instanceof ServerLevel)) {
            return null;
        }
        if (this.platformUUID != null) {
            LOGGER.error("[PlatformComponent] Platform UUID is set, but no entity found in level. Assuming removed.");
            this.platformUUID = null;
            this.isPlatformActive = false;
            return null;
        }
        return null;
    }

    private void removePlatformEntity() {
        if (this.level.f_46443_) {
            return;
        }
        GhastPlatformEntity platform = this.findPlatformEntity();
        if (platform != null) {
            platform.m_146870_();
        }
        this.platformUUID = null;
    }

    private boolean isAnyoneStandingOnTop() {
        if (!this.isPlatformActive || this.level.f_46443_) {
            return false;
        }
        double platformBaseY = this.owner.m_20186_() + 3.65;
        AABB checkZone = new AABB(this.owner.m_20185_() - 2.1, platformBaseY - 0.1, this.owner.m_20189_() - 2.1, this.owner.m_20185_() + 2.1, platformBaseY + 2.0, this.owner.m_20189_() + 2.1);
        List entitiesInZone = this.level.m_6249_((Entity)this.owner, checkZone, entity -> entity instanceof LivingEntity && entity.m_20202_() != this.owner && entity.m_20186_() >= platformBaseY - 0.05 && !(entity instanceof GhastPlatformEntity));
        return !entitiesInZone.isEmpty();
    }

    public boolean shouldDisableCollisionWith(Entity otherEntity) {
        if (!this.isPlatformActive || this.level.f_46443_) {
            return false;
        }
        if (otherEntity instanceof GhastPlatformEntity && otherEntity.m_20148_().equals(this.platformUUID)) {
            return true;
        }
        if (otherEntity instanceof LivingEntity) {
            double checkStartY = this.owner.m_20186_() + 3.65 - 0.5;
            double checkEndY = this.owner.m_20186_() + 3.65 + 2.0 + 0.5;
            AABB collisionCheckZone = new AABB(this.owner.m_20185_() - 2.1, checkStartY, this.owner.m_20189_() - 2.1, this.owner.m_20185_() + 2.1, checkEndY, this.owner.m_20189_() + 2.1);
            if (collisionCheckZone.m_82381_(otherEntity.m_20191_())) {
                return true;
            }
        }
        return false;
    }

    public void onOwnerRemoved() {
        if (!this.level.f_46443_) {
            this.removePlatformEntity();
            this.isPlatformActive = false;
            this.platformGracePeriodTicks = 0;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        CompoundTag platformTag = new CompoundTag();
        platformTag.m_128379_("IsActive", this.isPlatformActive);
        if (this.platformUUID != null) {
            platformTag.m_128362_("PlatformUUID", this.platformUUID);
        }
        platformTag.m_128405_("GraceTicks", this.platformGracePeriodTicks);
        compound.m_128365_("GhastPlatformComponent", (Tag)platformTag);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.m_128425_("GhastPlatformComponent", 10)) {
            CompoundTag platformTag = compound.m_128469_("GhastPlatformComponent");
            this.isPlatformActive = platformTag.m_128471_("IsActive");
            if (platformTag.m_128403_("PlatformUUID")) {
                this.platformUUID = platformTag.m_128342_("PlatformUUID");
            } else {
                this.platformUUID = null;
                if (this.isPlatformActive) {
                    this.isPlatformActive = false;
                }
            }
            this.platformGracePeriodTicks = platformTag.m_128451_("GraceTicks");
        } else {
            this.isPlatformActive = false;
            this.platformUUID = null;
            this.platformGracePeriodTicks = 0;
        }
    }
}

