/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import dev.nweaver.happyghastmod.entity.components.GhastRidingComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastMovementComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HappyGhast owner;
    private final GhastDataComponent dataComponent;
    private final GhastPlatformComponent platformComponent;
    private final GhastRidingComponent ridingComponent;
    public static float SPEED_MULTIPLIER = 1.0f;
    private static final float BASE_FORWARD_SPEED = 0.25f;
    private static final float ORIGINAL_FORWARD_SPEED = 0.3f;
    private static final float MAX_VERTICAL_SPEED = 0.25f;
    private static final double MIN_SPEED_THRESHOLD = 0.001;
    private static final float ACCELERATION_RATE = 0.15f;
    private static final float DECELERATION_RATE = 0.08f;
    private Vec3 targetVelocity = Vec3.f_82478_;
    private Vec3 currentVelocity = Vec3.f_82478_;
    private int rideSoundCounter = 0;
    private static final int RIDE_SOUND_INTERVAL = 80;

    public GhastMovementComponent(HappyGhast owner, GhastDataComponent dataComponent, GhastPlatformComponent platformComponent, GhastRidingComponent ridingComponent) {
        this.owner = owner;
        this.dataComponent = dataComponent;
        this.platformComponent = platformComponent;
        this.ridingComponent = ridingComponent;
    }

    private float getSpeedMultiplier() {
        return this.owner.getSpeedMultiplier();
    }

    public void handleTravel(Vec3 travelVector) {
        if (!this.owner.m_6084_()) {
            return;
        }
        if (!this.owner.f_19853_.f_46443_ && this.platformComponent.isActive()) {
            this.targetVelocity = Vec3.f_82478_;
            this.currentVelocity = Vec3.f_82478_;
            this.owner.m_20256_(Vec3.f_82478_);
            this.owner.m_21573_().m_26573_();
            return;
        }
        LivingEntity controller = this.ridingComponent.getControllingPassenger();
        if (this.owner.m_20160_() && controller instanceof Player) {
            Player player = (Player)controller;
            this.handleRiderControlledMovement(player);
            return;
        }
    }

    private void handleRiderControlledMovement(Player player) {
        boolean hasVerticalInput;
        boolean isLocalPlayer;
        float speedMultiplier = this.getSpeedMultiplier();
        boolean bl = isLocalPlayer = this.owner.f_19853_.f_46443_ && Minecraft.m_91087_().f_91074_ == player;
        if (isLocalPlayer) {
            this.owner.m_146922_(player.m_146908_());
            this.owner.m_146926_(player.m_146909_() * 0.5f);
            this.owner.f_20883_ = this.owner.m_146908_();
            this.owner.f_20885_ = this.owner.m_146908_();
        } else {
            float yRotDiff = player.m_146908_() - this.owner.m_146908_();
            if (yRotDiff > 180.0f) {
                yRotDiff -= 360.0f;
            }
            if (yRotDiff < -180.0f) {
                yRotDiff += 360.0f;
            }
            float serverSmoothFactor = 0.3f;
            this.owner.m_146922_(this.owner.m_146908_() + yRotDiff * serverSmoothFactor);
            this.owner.m_146926_(player.m_146909_() * 0.5f);
            this.owner.f_20883_ = this.owner.m_146908_();
            this.owner.f_20885_ = this.owner.m_146908_();
        }
        float forwardInput = player.f_20902_;
        float sideInput = player.f_20900_;
        double verticalMotion = 0.0;
        if (this.dataComponent.isAscending()) {
            verticalMotion = 0.25f * speedMultiplier;
        } else if (this.dataComponent.isDescending() || player.m_6144_()) {
            verticalMotion = -0.25f * speedMultiplier;
        }
        boolean hasHorizontalInput = forwardInput != 0.0f || sideInput != 0.0f;
        boolean bl2 = hasVerticalInput = verticalMotion != 0.0;
        if (!this.owner.f_19853_.f_46443_ && (hasHorizontalInput || hasVerticalInput)) {
            ++this.rideSoundCounter;
            if (this.rideSoundCounter >= 80) {
                this.owner.playRideSound();
                this.rideSoundCounter = 0;
            }
        }
        if (hasHorizontalInput || hasVerticalInput) {
            double yawRadians = Math.toRadians(-this.owner.m_146908_());
            double motionX = 0.0;
            double motionZ = 0.0;
            if (forwardInput != 0.0f) {
                motionX += Math.sin(yawRadians) * (double)forwardInput * 0.25 * (double)speedMultiplier;
                motionZ += Math.cos(yawRadians) * (double)forwardInput * 0.25 * (double)speedMultiplier;
            }
            if (sideInput != 0.0f) {
                motionX += Math.sin(yawRadians + 1.5707963267948966) * (double)sideInput * 0.25 * (double)speedMultiplier;
                motionZ += Math.cos(yawRadians + 1.5707963267948966) * (double)sideInput * 0.25 * (double)speedMultiplier;
            }
            this.targetVelocity = new Vec3(motionX, verticalMotion, motionZ);
            if (isLocalPlayer) {
                this.currentVelocity = this.currentVelocity.m_82520_((this.targetVelocity.f_82479_ - this.currentVelocity.f_82479_) * (double)0.3f, (this.targetVelocity.f_82480_ - this.currentVelocity.f_82480_) * (double)0.3f, (this.targetVelocity.f_82481_ - this.currentVelocity.f_82481_) * (double)0.3f);
            } else {
                float accelerationFactor = 0.15f;
                if (speedMultiplier > 1.0f) {
                    accelerationFactor *= Math.min(speedMultiplier, 3.0f) / 2.0f;
                }
                this.currentVelocity = this.currentVelocity.m_82520_((this.targetVelocity.f_82479_ - this.currentVelocity.f_82479_) * (double)accelerationFactor, (this.targetVelocity.f_82480_ - this.currentVelocity.f_82480_) * (double)accelerationFactor, (this.targetVelocity.f_82481_ - this.currentVelocity.f_82481_) * (double)accelerationFactor);
            }
            this.owner.m_20256_(this.currentVelocity);
            Vec3 fallbackMovement = new Vec3((double)(sideInput * speedMultiplier * 0.25f / 0.3f) * 0.5, verticalMotion, (double)(forwardInput * speedMultiplier * 0.25f / 0.3f) * 0.5);
            this.owner.applyControlledMovement(fallbackMovement);
        } else {
            if (!this.currentVelocity.equals((Object)Vec3.f_82478_)) {
                double decelerationFactor = 1.0 - (isLocalPlayer ? (double)0.12f : (double)0.08f);
                this.currentVelocity = this.currentVelocity.m_82542_(decelerationFactor, decelerationFactor, decelerationFactor);
                if (this.currentVelocity.m_82556_() < 0.001) {
                    this.currentVelocity = Vec3.f_82478_;
                }
                this.owner.m_20256_(this.currentVelocity);
            } else {
                this.owner.m_20256_(Vec3.f_82478_);
            }
            this.owner.applyControlledMovement(Vec3.f_82478_);
        }
    }

    public boolean isPushable() {
        return this.owner.f_19853_.f_46443_ || !this.platformComponent.isActive();
    }

    public boolean canCollideWith(Entity otherEntity) {
        return !this.platformComponent.shouldDisableCollisionWith(otherEntity);
    }
}

