/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class GhastLeashComponent {
    private final HappyGhast owner;
    private static final double MAX_LEASH_DISTANCE = 5.0;
    private static final double MAX_LEASH_DISTANCE_SQR = 25.0;
    private static final double LEASH_PULL_STRENGTH = 0.03;
    private static final double LEASH_VERTICAL_PULL_STRENGTH = 0.02;
    private static final double MOTION_DAMPING = 0.9;
    private static final double VERTICAL_DAMPING = 0.95;
    private Vec3 smoothedPullForce = Vec3.f_82478_;
    private static final double PULL_FORCE_SMOOTHING = 0.2;
    private static final double COMFORT_ZONE_RATIO = 0.8;
    private static final double COMFORT_ZONE_SQR = 20.0;

    public GhastLeashComponent(HappyGhast owner) {
        this.owner = owner;
    }

    public InteractionResult handleLeashInteraction(Player player, InteractionHand hand, GhastPlatformComponent platformComponent) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.owner.m_20363_((Entity)player)) {
            return InteractionResult.PASS;
        }
        if (itemstack.m_150930_(Items.f_42655_)) {
            if (this.owner.isSaddled()) {
                return InteractionResult.CONSUME;
            }
            if (!(this.owner.m_21523_() || this.owner.m_20160_() || platformComponent != null && platformComponent.isActive())) {
                if (!this.owner.f_19853_.f_46443_) {
                    this.owner.m_21463_((Entity)player, true);
                    this.owner.m_146852_(GameEvent.f_223708_, (Entity)player);
                }
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.owner.f_19853_.m_6269_(null, (Entity)this.owner, SoundEvents.f_12087_, SoundSource.NEUTRAL, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.owner.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canBeLeashed(Player player, GhastPlatformComponent platformComponent) {
        return !this.owner.m_21523_() && !this.owner.m_20160_() && !this.owner.m_20363_((Entity)player) && (platformComponent == null || !platformComponent.isActive());
    }

    public void onLeashDropped(boolean broadcast, boolean dropItem) {
        this.smoothedPullForce = Vec3.f_82478_;
    }

    public void tickLeash() {
        if (!this.owner.f_19853_.f_46443_ && this.owner.m_21523_()) {
            Entity leashHolder = this.owner.m_21524_();
            if (leashHolder != null) {
                double distanceSqr = this.owner.m_20280_(leashHolder);
                Vec3 currentDelta = this.owner.m_20184_();
                Vec3 dampedDelta = currentDelta.m_82542_(0.9, 0.95, 0.9);
                if (distanceSqr > 20.0) {
                    Vec3 currentPos = this.owner.m_20182_();
                    Vec3 holderPos = leashHolder.m_20182_();
                    Vec3 vectorToHolder = holderPos.m_82546_(currentPos);
                    double currentDist = Math.sqrt(distanceSqr);
                    double maxDist = Math.sqrt(25.0);
                    double comfortDist = Math.sqrt(20.0);
                    double overshootRatio = Math.min(1.0, (currentDist - comfortDist) / (maxDist - comfortDist));
                    double pullStrengthFactor = overshootRatio * overshootRatio * 0.03;
                    Vec3 rawPullForce = vectorToHolder.m_82541_().m_82490_(pullStrengthFactor);
                    this.smoothedPullForce = this.smoothedPullForce == Vec3.f_82478_ ? rawPullForce : this.smoothedPullForce.m_82490_(0.8).m_82549_(rawPullForce.m_82490_(0.2));
                    double verticalDiff = holderPos.f_82480_ - currentPos.f_82480_;
                    Vec3 extraVerticalForce = Vec3.f_82478_;
                    if (Math.abs(verticalDiff) > 1.0) {
                        double verticalRatio = Math.min(Math.abs(verticalDiff) / 10.0, 1.0);
                        double yPullStrength = verticalRatio * verticalRatio * 0.02;
                        extraVerticalForce = new Vec3(0.0, Math.signum(verticalDiff) * yPullStrength, 0.0);
                    }
                    Vec3 newDelta = dampedDelta.m_82549_(this.smoothedPullForce).m_82549_(extraVerticalForce);
                    double maxSpeed = 0.3;
                    if (newDelta.m_82553_() > maxSpeed) {
                        newDelta = newDelta.m_82541_().m_82490_(maxSpeed);
                    }
                    this.owner.m_20256_(newDelta);
                } else {
                    this.owner.m_20256_(dampedDelta);
                    if (this.smoothedPullForce != Vec3.f_82478_) {
                        this.smoothedPullForce = this.smoothedPullForce.m_82490_(0.8);
                        if (this.smoothedPullForce.m_82556_() < 1.0E-4) {
                            this.smoothedPullForce = Vec3.f_82478_;
                        }
                    }
                }
            }
        } else {
            this.smoothedPullForce = Vec3.f_82478_;
        }
    }
}

