/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.container.GhastContainer;
import dev.nweaver.happyghastmod.custom.CustomHarnessManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.item.CustomHarnessItem;
import dev.nweaver.happyghastmod.item.HarnessItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastInventoryComponent
implements Container {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HappyGhast owner;
    private final GhastDataComponent dataComponent;
    private final SimpleContainer inventory;
    private final List<ContainerListener> listeners = new ArrayList<ContainerListener>();
    private static final boolean DEBUG_LOGGING = false;

    public GhastInventoryComponent(HappyGhast owner, GhastDataComponent dataComponent) {
        this.owner = owner;
        this.dataComponent = dataComponent;
        this.inventory = new SimpleContainer(1);
        this.syncInventoryWithState();
        this.inventory.m_19164_(this::onInventoryChanged);
    }

    public ItemStack createCustomHarnessItem(String customId) {
        return this.createCustomHarnessItemStack(customId);
    }

    private ItemStack createCustomHarnessItemStack(String customId) {
        ItemStack stack = null;
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof HarnessItem)) continue;
            stack = new ItemStack((ItemLike)item);
            break;
        }
        if (stack == null) {
            LOGGER.error("Failed to find any HarnessItem for custom harness creation");
            return ItemStack.f_41583_;
        }
        CustomHarnessManager.CustomHarnessData data = CustomHarnessManager.getCustomHarnessData(customId);
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("CustomHarnessId", customId);
        if (data != null) {
            CompoundTag display = new CompoundTag();
            display.m_128359_("Name", "{\"text\":\"" + data.getName() + "\",\"italic\":false}");
            tag.m_128365_("display", (Tag)display);
            if (data.hasSaddleTexture()) {
                tag.m_128379_("HasCustomSaddleTexture", true);
            }
            if (data.hasGlassesTexture()) {
                tag.m_128379_("HasCustomGlassesTexture", true);
            }
            if (data.hasAccessoryTexture()) {
                tag.m_128379_("HasCustomAccessoryTexture", true);
            }
        }
        return stack;
    }

    public void openInventory(Player player) {
        if (!this.owner.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.owner.m_20160_() && this.owner.m_20363_((Entity)player)) {
                this.syncInventoryWithState();
                SimpleMenuProvider provider = new SimpleMenuProvider((windowId, playerInventory, p) -> new GhastContainer(windowId, playerInventory, this, this.owner), (Component)Component.m_237115_((String)"container.happyghastmod.ghast"));
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)provider, buffer -> buffer.writeInt(this.owner.m_19879_()));
            }
        }
    }

    public boolean canUseInventory(Player player) {
        return this.owner.m_20160_() && this.owner.m_20363_((Entity)player);
    }

    private void onInventoryChanged(Container container) {
        ItemStack saddleStack = container.m_8020_(0);
        if (saddleStack.m_41619_()) {
            if (this.dataComponent.isSaddled()) {
                this.dataComponent.setSaddled(false);
            }
        } else if (saddleStack.m_41720_() instanceof HarnessItem) {
            this.dataComponent.setSaddled(true);
            String customHarnessId = CustomHarnessItem.getCustomHarnessId(saddleStack);
            if (customHarnessId != null) {
                this.dataComponent.setHarnessColor("custom:" + customHarnessId);
            } else {
                String color = ((HarnessItem)saddleStack.m_41720_()).getColor();
                this.dataComponent.setHarnessColor(color);
            }
        }
    }

    public void syncInventoryWithState() {
        if (this.dataComponent.isSaddled() && this.inventory.m_8020_(0).m_41619_()) {
            String color = this.dataComponent.getHarnessColor();
            if (color.startsWith("custom:")) {
                String customId = color.substring("custom:".length());
                ItemStack customStack = this.createCustomHarnessItemStack(customId);
                if (!customStack.m_41619_()) {
                    this.inventory.m_6836_(0, customStack);
                }
            } else {
                boolean found = false;
                for (Item item : ForgeRegistries.ITEMS) {
                    HarnessItem harnessItem;
                    if (!(item instanceof HarnessItem) || !(harnessItem = (HarnessItem)item).getColor().equals(color)) continue;
                    this.inventory.m_6836_(0, new ItemStack((ItemLike)item));
                    found = true;
                    break;
                }
            }
        } else if (!this.dataComponent.isSaddled() && !this.inventory.m_8020_(0).m_41619_()) {
            this.inventory.m_6836_(0, ItemStack.f_41583_);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        ListTag inventoryTag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128405_("Slot", i);
            stack.m_41739_(slotTag);
            if (stack.m_41720_() instanceof HarnessItem && CustomHarnessItem.getCustomHarnessId(stack) != null) {
                slotTag.m_128359_("CustomHarnessBackup", CustomHarnessItem.getCustomHarnessId(stack));
            }
            inventoryTag.add((Object)slotTag);
        }
        compound.m_128365_("GhastInventory", (Tag)inventoryTag);
        if (this.dataComponent.isSaddled()) {
            compound.m_128359_("DirectHarnessColor", this.dataComponent.getHarnessColor());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        String customId;
        ItemStack customStack;
        String color;
        if (compound.m_128425_("GhastInventory", 9)) {
            ListTag inventoryTag = compound.m_128437_("GhastInventory", 10);
            for (int i = 0; i < inventoryTag.size(); ++i) {
                CompoundTag slotTag = inventoryTag.m_128728_(i);
                int slot = slotTag.m_128451_("Slot");
                if (slot < 0 || slot >= this.inventory.m_6643_()) continue;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)slotTag);
                if (slotTag.m_128441_("CustomHarnessBackup") && stack.m_41720_() instanceof HarnessItem) {
                    CustomHarnessManager.CustomHarnessData data;
                    String backupId = slotTag.m_128461_("CustomHarnessBackup");
                    if (CustomHarnessItem.getCustomHarnessId(stack) == null) {
                        stack.m_41784_().m_128359_("CustomHarnessId", backupId);
                    }
                    if ((data = CustomHarnessManager.getCustomHarnessData(backupId)) != null && !stack.m_41788_()) {
                        CompoundTag display = stack.m_41698_("display");
                        display.m_128359_("Name", "{\"text\":\"" + data.getName() + "\",\"italic\":false}");
                        CompoundTag stackTag = stack.m_41784_();
                        if (data.hasSaddleTexture() && !stackTag.m_128441_("HasCustomSaddleTexture")) {
                            stackTag.m_128379_("HasCustomSaddleTexture", true);
                        }
                        if (data.hasGlassesTexture() && !stackTag.m_128441_("HasCustomGlassesTexture")) {
                            stackTag.m_128379_("HasCustomGlassesTexture", true);
                        }
                        if (data.hasAccessoryTexture() && !stackTag.m_128441_("HasCustomAccessoryTexture")) {
                            stackTag.m_128379_("HasCustomAccessoryTexture", true);
                        }
                    }
                }
                this.inventory.m_6836_(slot, stack);
            }
        } else {
            this.syncInventoryWithState();
        }
        if (compound.m_128441_("DirectHarnessColor") && (color = compound.m_128461_("DirectHarnessColor")).startsWith("custom:") && this.inventory.m_8020_(0).m_41619_() && !(customStack = this.createCustomHarnessItemStack(customId = color.substring("custom:".length()))).m_41619_()) {
            this.inventory.m_6836_(0, customStack);
        }
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public ItemStack m_8020_(int index) {
        return this.inventory.m_8020_(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return this.inventory.m_7407_(index, count);
    }

    public ItemStack m_8016_(int index) {
        return this.inventory.m_8016_(index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.m_6836_(index, stack);
    }

    public void m_6596_() {
        this.inventory.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return this.owner.m_6084_() && this.owner.m_20270_((Entity)player) < 8.0f && this.canUseInventory(player);
    }

    public void m_6211_() {
        this.inventory.m_6211_();
    }
}

