/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.custom.CustomHarnessManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.entity.components.GhastLeashComponent;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import dev.nweaver.happyghastmod.item.CustomHarnessItem;
import dev.nweaver.happyghastmod.item.HarnessItem;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastInteractionComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HappyGhast owner;
    private final GhastDataComponent dataComponent;
    private final GhastLeashComponent leashComponent;
    private final GhastPlatformComponent platformComponent;
    private static final boolean DEBUG_LOGGING = false;

    public GhastInteractionComponent(HappyGhast owner, GhastDataComponent dataComponent, GhastLeashComponent leashComponent, GhastPlatformComponent platformComponent) {
        this.owner = owner;
        this.dataComponent = dataComponent;
        this.leashComponent = leashComponent;
        this.platformComponent = platformComponent;
    }

    public InteractionResult handleInteraction(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_(Items.f_42452_)) {
            return this.handleSnowballFeeding(player, itemstack);
        }
        if (itemstack.m_150930_(Items.f_42574_) && this.dataComponent.isSaddled()) {
            return this.handleSaddleRemoval(player);
        }
        InteractionResult leashResult = this.leashComponent.handleLeashInteraction(player, hand, this.platformComponent);
        if (leashResult != InteractionResult.PASS) {
            return leashResult;
        }
        if (!this.dataComponent.isSaddled()) {
            Item item = itemstack.m_41720_();
            if (item instanceof HarnessItem) {
                HarnessItem harnessItem = (HarnessItem)item;
                String customHarnessId = CustomHarnessItem.getCustomHarnessId(itemstack);
                return this.handleSaddleInteraction(player, itemstack, harnessItem.getColor());
            }
        } else if (this.dataComponent.isSaddled() && !player.m_36341_() && !itemstack.m_150930_(Items.f_42655_)) {
            return this.handleMounting(player);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleSaddleInteraction(Player player, ItemStack itemstack, String color) {
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        this.dataComponent.setSaddled(true);
        String customHarnessId = CustomHarnessItem.getCustomHarnessId(itemstack);
        if (customHarnessId != null) {
            this.dataComponent.setHarnessColor("custom:" + customHarnessId);
        } else {
            this.dataComponent.setHarnessColor(color);
        }
        if (this.owner.getInventoryComponent() != null) {
            this.owner.getInventoryComponent().syncInventoryWithState();
        }
        this.owner.playHarnessEquipSound();
        return InteractionResult.m_19078_((boolean)this.owner.f_19853_.f_46443_);
    }

    private InteractionResult handleSnowballFeeding(Player player, ItemStack itemstack) {
        if (!this.owner.f_19853_.f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.owner.m_5634_(2.0f);
            this.owner.f_19853_.m_6263_(null, this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (this.owner.m_217043_().m_188501_() - this.owner.m_217043_().m_188501_()) * 0.2f);
            Level level = this.owner.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double d0 = this.owner.m_20191_().m_82399_().f_82479_;
                double d1 = this.owner.m_20191_().m_82399_().f_82480_;
                double d2 = this.owner.m_20191_().m_82399_().f_82481_;
                for (int i = 0; i < 5; ++i) {
                    double offsetX = this.owner.m_217043_().m_188583_() * 0.8;
                    double offsetY = this.owner.m_217043_().m_188583_() * 0.8;
                    double offsetZ = this.owner.m_217043_().m_188583_() * 0.8;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, d0 + offsetX, d1 + offsetY, d2 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)this.owner.f_19853_.f_46443_);
    }

    private InteractionResult handleMounting(Player player) {
        if (!this.owner.f_19853_.f_46443_) {
            boolean success;
            if (this.owner.m_21523_()) {
                Entity leashHolder = this.owner.m_21524_();
                this.owner.m_21455_(true, false);
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42655_));
                if (leashHolder instanceof LeashFenceKnotEntity) {
                    LeashFenceKnotEntity knot = (LeashFenceKnotEntity)leashHolder;
                    knot.m_146870_();
                }
            }
            if (this.platformComponent != null && this.platformComponent.isActive()) {
                this.platformComponent.deactivate();
            }
            if (success = player.m_20329_((Entity)this.owner)) {
                this.owner.playGogglesDownSound();
            } else {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.m_19078_((boolean)this.owner.f_19853_.f_46443_);
    }

    private InteractionResult handleSaddleRemoval(Player player) {
        if (!this.owner.f_19853_.f_46443_) {
            ItemStack harnessStack;
            String harnessColor = this.dataComponent.getHarnessColor();
            this.dataComponent.setSaddled(false);
            if (harnessColor.startsWith("custom:")) {
                String customId = harnessColor.substring(7);
                Item baseItem = null;
                for (Item item : ForgeRegistries.ITEMS) {
                    if (!(item instanceof HarnessItem)) continue;
                    baseItem = item;
                    break;
                }
                if (baseItem != null) {
                    harnessStack = new ItemStack(baseItem);
                    CustomHarnessManager.CustomHarnessData data = CustomHarnessManager.getCustomHarnessData(customId);
                    if (data != null) {
                        CompoundTag tag = harnessStack.m_41784_();
                        tag.m_128359_("CustomHarnessId", customId);
                        tag.m_128359_("CustomHarnessName", data.getName());
                        if (data.hasSaddleTexture()) {
                            tag.m_128379_("HasCustomSaddleTexture", true);
                        }
                        if (data.hasGlassesTexture()) {
                            tag.m_128379_("HasCustomGlassesTexture", true);
                        }
                        if (data.hasAccessoryTexture()) {
                            tag.m_128379_("HasCustomAccessoryTexture", true);
                        }
                        CompoundTag display = new CompoundTag();
                        display.m_128359_("Name", "{\"text\":\"" + data.getName() + "\",\"italic\":false}");
                        tag.m_128365_("display", (Tag)display);
                    } else {
                        harnessStack = new ItemStack((ItemLike)this.getHarnessItemForColor("blue"));
                    }
                } else {
                    harnessStack = new ItemStack((ItemLike)this.getHarnessItemForColor("blue"));
                }
            } else {
                harnessStack = new ItemStack((ItemLike)this.getHarnessItemForColor(harnessColor));
            }
            if (!player.m_150109_().m_36054_(harnessStack)) {
                player.m_36176_(harnessStack, false);
            }
            this.owner.playHarnessUnequipSound();
            Level level = this.owner.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.owner.m_20185_(), this.owner.m_20186_() + 1.0, this.owner.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
            }
        }
        return InteractionResult.m_19078_((boolean)this.owner.f_19853_.f_46443_);
    }

    private Item getHarnessItemForColor(String color) {
        HarnessItem harnessItem;
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof HarnessItem) || !(harnessItem = (HarnessItem)item).getColor().equals(color)) continue;
            return item;
        }
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof HarnessItem) || !(harnessItem = (HarnessItem)item).getColor().equals("blue")) continue;
            return item;
        }
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof HarnessItem)) continue;
            return item;
        }
        return Items.f_42450_;
    }
}

