/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.entity.components.GhastInteractionComponent;
import dev.nweaver.happyghastmod.entity.components.GhastInventoryComponent;
import dev.nweaver.happyghastmod.entity.components.GhastLeashComponent;
import dev.nweaver.happyghastmod.entity.components.GhastMovementComponent;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import dev.nweaver.happyghastmod.entity.components.GhastRidingComponent;
import dev.nweaver.happyghastmod.entity.goals.HappyGhastFollowPlayerWithItemGoal;
import dev.nweaver.happyghastmod.entity.goals.HappyGhastLookGoal;
import dev.nweaver.happyghastmod.entity.goals.HappyGhastRandomFloatGoal;
import dev.nweaver.happyghastmod.init.SoundInit;
import dev.nweaver.happyghastmod.network.GhastRotationSyncPacket;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HappyGhast
extends Ghast {
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.m_135353_(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DESCENDING_ID = SynchedEntityData.m_135353_(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ASCENDING_ID = SynchedEntityData.m_135353_(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DATA_HARNESS_COLOR = SynchedEntityData.m_135353_(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SPEED_MULTIPLIER = SynchedEntityData.m_135353_(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float lastSyncedYRot;
    private float lastSyncedXRot;
    private static final float ROTATION_SYNC_THRESHOLD = 2.5f;
    private static final int ROTATION_SYNC_INTERVAL = 5;
    private int rotationSyncCooldown = 0;
    private GhastDataComponent dataComponent;
    private GhastLeashComponent leashComponent;
    private GhastPlatformComponent platformComponent;
    private GhastRidingComponent ridingComponent;
    private GhastInteractionComponent interactionComponent;
    private GhastMovementComponent movementComponent;
    private GhastInventoryComponent inventoryComponent;
    private float targetServerYRot;
    private float targetServerXRot;
    private float targetServerYBodyRot;
    private float targetServerYHeadRot;
    private boolean hasTargetRotation = false;
    private int rotationSyncCounter = 0;
    private static final int CLOUD_LEVEL = 195;
    private static final int REGEN_INTERVAL = 50;
    private int regenCounter = 0;
    private static final boolean DEBUG_ROTATION = false;
    private long lastDebugLogTime = 0L;
    private static final Logger LOGGER = LogManager.getLogger(HappyGhast.class);
    private static int tickLogCounter = 0;
    private static final int TICK_LOG_INTERVAL = 50;
    private long lastLoggedTick = 0L;
    private static final int LOG_INTERVAL = 50;
    private float lastSyncedYRotValue = Float.NaN;
    private float lastSyncedXRotValue = Float.NaN;

    public HappyGhast(EntityType<? extends Ghast> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
        this.initComponents();
        if (!this.f_19853_.f_46443_) {
            this.setSpeedMultiplier(GhastMovementComponent.SPEED_MULTIPLIER);
        }
    }

    private void initComponents() {
        if (this.dataComponent == null) {
            this.dataComponent = new GhastDataComponent(this);
        }
        if (this.platformComponent == null) {
            this.platformComponent = new GhastPlatformComponent(this);
        }
        if (this.leashComponent == null) {
            this.leashComponent = new GhastLeashComponent(this);
        }
        if (this.ridingComponent == null) {
            this.ridingComponent = new GhastRidingComponent(this, this.dataComponent, this.platformComponent);
        }
        if (this.movementComponent == null) {
            this.movementComponent = new GhastMovementComponent(this, this.dataComponent, this.platformComponent, this.ridingComponent);
        }
        if (this.interactionComponent == null) {
            this.interactionComponent = new GhastInteractionComponent(this, this.dataComponent, this.leashComponent, this.platformComponent);
        }
        if (this.inventoryComponent == null) {
            this.inventoryComponent = new GhastInventoryComponent(this, this.dataComponent);
        }
    }

    public <T> T getEntityDataValue(EntityDataAccessor<T> key) {
        return (T)this.f_19804_.m_135370_(key);
    }

    public <T> void setEntityDataValue(EntityDataAccessor<T> key, T value) {
        this.f_19804_.m_135381_(key, value);
    }

    protected boolean m_8028_() {
        return false;
    }

    public int getMaxPassengers() {
        return 4;
    }

    public GhastInventoryComponent getInventoryComponent() {
        if (this.inventoryComponent == null) {
            if (this.dataComponent == null) {
                this.initComponents();
            }
            this.inventoryComponent = new GhastInventoryComponent(this, this.dataComponent);
        }
        return this.inventoryComponent;
    }

    public void m_5616_(float yHeadRot) {
        super.m_5616_(yHeadRot);
        if (this.f_19853_.f_46443_ || this.m_20160_()) {
            // empty if block
        }
    }

    public void m_5618_(float yBodyRot) {
        super.m_5618_(yBodyRot);
        if (this.f_19853_.f_46443_ || this.m_20160_()) {
            // empty if block
        }
    }

    public void m_146922_(float yRot) {
        float oldYRot = this.m_146908_();
        super.m_146922_(yRot);
        if (this.f_19853_.f_46443_ || this.m_20160_()) {
            // empty if block
        }
    }

    public void m_146926_(float xRot) {
        float oldXRot = this.m_146909_();
        super.m_146926_(xRot);
        if (this.f_19853_.f_46443_ || this.m_20160_()) {
            // empty if block
        }
    }

    private void syncRotationToClients() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.rotationSyncCooldown > 0) {
            --this.rotationSyncCooldown;
            return;
        }
        float yRotDiff = Math.abs(Mth.m_14177_((float)(this.m_146908_() - this.lastSyncedYRot)));
        float xRotDiff = Math.abs(this.m_146909_() - this.lastSyncedXRot);
        if (yRotDiff < 2.5f && xRotDiff < 2.5f && this.rotationSyncCounter < 5) {
            ++this.rotationSyncCounter;
            return;
        }
        this.lastSyncedYRot = this.m_146908_();
        this.lastSyncedXRot = this.m_146909_();
        this.rotationSyncCounter = 0;
        GhastRotationSyncPacket packet = new GhastRotationSyncPacket(this.m_19879_(), this.m_146908_(), this.m_146909_(), this.f_20883_, this.f_20885_);
        this.rotationSyncCooldown = 5;
        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)packet);
    }

    public void setTargetServerRotation(float yRot, float xRot, float yBodyRot, float yHeadRot) {
        this.targetServerYRot = yRot;
        this.targetServerXRot = xRot;
        this.targetServerYBodyRot = yBodyRot;
        this.targetServerYHeadRot = yHeadRot;
        this.hasTargetRotation = true;
    }

    public void setEntityRotation(float yRot, float xRot) {
        this.m_19915_(yRot, xRot);
    }

    public GhastPlatformComponent getPlatformComponent() {
        if (this.platformComponent == null && !this.f_19853_.f_46443_) {
            return this.platformComponent;
        }
        return this.platformComponent;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SADDLE_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_ASCENDING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_DESCENDING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_HARNESS_COLOR, (Object)"blue");
        this.f_19804_.m_135372_(DATA_SPEED_MULTIPLIER, (Object)Float.valueOf(1.0f));
    }

    public boolean isSaddled() {
        return this.getEntityDataValue(DATA_SADDLE_ID);
    }

    public String getHarnessColor() {
        return this.getEntityDataValue(DATA_HARNESS_COLOR);
    }

    public void setHarnessColor(String color) {
        this.setEntityDataValue(DATA_HARNESS_COLOR, color);
    }

    public void setSaddled(boolean saddled) {
        this.setEntityDataValue(DATA_SADDLE_ID, saddled);
    }

    public boolean isAscending() {
        return this.getEntityDataValue(DATA_ASCENDING_ID);
    }

    public void setAscending(boolean ascending) {
        this.setEntityDataValue(DATA_ASCENDING_ID, ascending);
    }

    public boolean m_20164_() {
        return this.getEntityDataValue(DATA_DESCENDING_ID);
    }

    public void setDescending(boolean descending) {
        this.setEntityDataValue(DATA_DESCENDING_ID, descending);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        AnchorManager.setAnchorWithCooldown((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (this.interactionComponent != null) {
            return this.interactionComponent.handleInteraction(player, hand);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_7310_(Entity passenger) {
        return this.ridingComponent != null && this.ridingComponent.canAddPassenger(passenger);
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (this.ridingComponent != null) {
            this.ridingComponent.handlePassengerRemoval(passenger);
        }
    }

    public LivingEntity getControllingPassenger() {
        return this.ridingComponent != null ? this.ridingComponent.getControllingPassenger() : null;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public void m_7332_(Entity passenger) {
        if (this.ridingComponent != null) {
            this.ridingComponent.positionRider(passenger, null);
        } else {
            super.m_7332_(passenger);
        }
    }

    public void m_7340_(Entity passenger) {
        super.m_7340_(passenger);
        if (this.ridingComponent != null) {
            this.ridingComponent.handlePassengerTurned(passenger);
        }
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        return this.ridingComponent != null ? this.ridingComponent.getDismountLocationForPassenger(passenger) : super.m_7688_(passenger);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.movementComponent != null) {
            this.movementComponent.handleTravel(travelVector);
            if (this.m_20160_() || !this.m_6084_() || this.platformComponent != null && this.platformComponent.isActive() && !this.f_19853_.f_46443_) {
                return;
            }
        }
        super.m_7023_(travelVector);
    }

    public void applyControlledMovement(Vec3 movement) {
        super.m_7023_(movement);
    }

    public void m_7334_(Entity entity) {
        if (this.platformComponent == null || !this.platformComponent.shouldDisableCollisionWith(entity)) {
            super.m_7334_(entity);
        }
    }

    public void m_5997_(double dx, double dy, double dz) {
        if (this.f_19853_.f_46443_ || this.platformComponent == null || !this.platformComponent.isActive()) {
            super.m_5997_(dx, dy, dz);
        }
    }

    public boolean m_6094_() {
        return this.movementComponent != null ? this.movementComponent.isPushable() : super.m_6094_();
    }

    public boolean m_7337_(Entity otherEntity) {
        return (this.movementComponent == null || this.movementComponent.canCollideWith(otherEntity)) && super.m_7337_(otherEntity);
    }

    private void serverTick() {
        Vec3 deceleration;
        if (this.dataComponent == null) {
            this.initComponents();
            if ((long)this.f_19797_ - this.lastLoggedTick >= 50L) {
                LOGGER.debug("Components initialized in tick()");
                this.lastLoggedTick = this.f_19797_;
            }
        }
        if (this.inventoryComponent == null && this.dataComponent != null) {
            this.inventoryComponent = new GhastInventoryComponent(this, this.dataComponent);
            if ((long)this.f_19797_ - this.lastLoggedTick >= 50L) {
                LOGGER.debug("Inventory component initialized in tick()");
                this.lastLoggedTick = this.f_19797_;
            }
        }
        if (!AnchorManager.hasAnchor((Entity)this)) {
            AnchorManager.setAnchor((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_());
            if ((long)this.f_19797_ - this.lastLoggedTick >= 50L) {
                LOGGER.debug("Anchor position initialized at spawn: {}, {}, {}", (Object)this.m_20185_(), (Object)this.m_20186_(), (Object)this.m_20189_());
            }
        }
        this.handleHealthRegeneration();
        if (!AnchorManager.isFollowing((Entity)this) && !this.m_20160_() && (deceleration = AnchorManager.getDecelerationVector((Entity)this)) != Vec3.f_82478_ && deceleration.m_82556_() > 1.0E-4) {
            this.m_20256_(deceleration);
        }
        if (!this.f_19853_.f_46443_) {
            LivingEntity driver;
            if (this.platformComponent != null) {
                this.platformComponent.tick();
            }
            if (this.m_21523_() && this.leashComponent != null) {
                this.leashComponent.tickLeash();
            }
            if (this.m_20160_() && (driver = this.getControllingPassenger()) != null) {
                float targetYRot = driver.m_146908_();
                float targetXRot = driver.m_146909_();
                float serverSmoothFactor = 0.2f;
                float yRotDiff = Mth.m_14177_((float)(targetYRot - this.m_146908_()));
                this.m_146922_(Mth.m_14177_((float)(this.m_146908_() + yRotDiff * serverSmoothFactor)));
                this.m_146926_(this.m_146909_() + (targetXRot * 0.5f - this.m_146909_()) * serverSmoothFactor);
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
                this.syncRotationToClients();
            }
        }
    }

    private void clientTick() {
        if (this.hasTargetRotation) {
            boolean isDriver;
            Minecraft minecraft = Minecraft.m_91087_();
            boolean bl = isDriver = minecraft.f_91074_ != null && this.m_20197_().contains(minecraft.f_91074_) && this.m_20197_().indexOf(minecraft.f_91074_) == 0;
            if (!isDriver) {
                float maxRotationStep = 3.0f;
                float yRotDiff = Mth.m_14177_((float)(this.targetServerYRot - this.m_146908_()));
                float xRotDiff = this.targetServerXRot - this.m_146909_();
                float yRotStep = Mth.m_14036_((float)yRotDiff, (float)(-maxRotationStep), (float)maxRotationStep);
                float xRotStep = Mth.m_14036_((float)xRotDiff, (float)(-maxRotationStep), (float)maxRotationStep);
                this.m_146922_(Mth.m_14177_((float)(this.m_146908_() + yRotStep)));
                this.m_146926_(this.m_146909_() + xRotStep);
                float bodyRotDiff = Mth.m_14177_((float)(this.targetServerYBodyRot - this.f_20883_));
                float bodyRotStep = Mth.m_14036_((float)bodyRotDiff, (float)(-maxRotationStep), (float)maxRotationStep);
                this.f_20885_ = this.f_20883_ = Mth.m_14177_((float)(this.f_20883_ + bodyRotStep));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    public GhastLeashComponent getLeashComponent() {
        return this.leashComponent;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.f_19853_.f_46443_) {
            AnchorManager.removeAnchor((Entity)this);
            if (this.platformComponent != null) {
                this.platformComponent.onOwnerRemoved();
                if (this.m_21523_()) {
                    this.m_21455_(true, false);
                }
            }
        }
        super.m_142687_(reason);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new HappyGhastFollowPlayerWithItemGoal(this, 1.0, 30.0f));
        this.f_21345_.m_25352_(5, (Goal)new HappyGhastRandomFloatGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new HappyGhastLookGoal(this));
    }

    public static AttributeSupplier.Builder m_32752_() {
        return Ghast.m_32752_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("BlueHarness", this.isSaddled());
        if (this.isSaddled()) {
            compound.m_128359_("HarnessColor", this.getHarnessColor());
        }
        compound.m_128350_("SpeedMultiplier", this.getSpeedMultiplier());
        if (this.dataComponent != null) {
            this.dataComponent.addAdditionalSaveData(compound);
        }
        if (this.platformComponent != null) {
            this.platformComponent.addAdditionalSaveData(compound);
        }
        if (this.inventoryComponent != null) {
            this.inventoryComponent.addAdditionalSaveData(compound);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.dataComponent == null) {
            this.initComponents();
        }
        if (compound.m_128441_("HarnessColor")) {
            this.setHarnessColor(compound.m_128461_("HarnessColor"));
        } else if (compound.m_128441_("BlueHarness") && compound.m_128471_("BlueHarness")) {
            this.setHarnessColor("blue");
        }
        if (compound.m_128441_("SpeedMultiplier")) {
            this.setSpeedMultiplier(compound.m_128457_("SpeedMultiplier"));
        } else {
            this.setSpeedMultiplier(GhastMovementComponent.SPEED_MULTIPLIER);
        }
        this.dataComponent.readAdditionalSaveData(compound);
        this.platformComponent.readAdditionalSaveData(compound);
        if (this.inventoryComponent != null) {
            this.inventoryComponent.readAdditionalSaveData(compound);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_32758_(boolean charging) {
        super.m_32758_(false);
    }

    public void m_21463_(Entity entity, boolean sendPacket) {
        super.m_21463_(entity, sendPacket);
        if (this.leashComponent != null) {
            this.leashComponent.onLeashDropped(false, false);
        }
    }

    public boolean m_6573_(Player player) {
        return this.leashComponent != null && this.platformComponent != null && this.leashComponent.canBeLeashed(player, this.platformComponent);
    }

    public void m_21455_(boolean broadcast, boolean dropItem) {
        super.m_21455_(broadcast, dropItem);
        if (this.leashComponent != null) {
            this.leashComponent.onLeashDropped(broadcast, dropItem);
        }
    }

    public boolean m_21532_() {
        return true;
    }

    public void refreshSaddle() {
        boolean currentSaddled = this.isSaddled();
        String currentColor = this.getHarnessColor();
        if (this.f_19853_.f_46443_) {
            this.setSaddled(currentSaddled);
            this.setHarnessColor(currentColor);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.HAPPY_GHAST_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.HAPPY_GHAST_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.HAPPY_GHAST_DEATH.get();
    }

    public void playRideSound() {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.HAPPY_GHAST_RIDE.get(), this.m_5720_(), 1.0f, 1.0f);
        }
    }

    public void playGogglesDownSound() {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.HAPPY_GHAST_GOGGLES_DOWN.get(), this.m_5720_(), 1.0f, 1.0f);
        }
    }

    public void playGogglesUpSound() {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.HAPPY_GHAST_GOGGLES_UP.get(), this.m_5720_(), 1.0f, 1.0f);
        }
    }

    public void playHarnessEquipSound() {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.HAPPY_GHAST_HARNESS_EQUIP.get(), this.m_5720_(), 1.0f, 1.0f);
        }
    }

    public void playHarnessUnequipSound() {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.HAPPY_GHAST_HARNESS_UNEQUIP.get(), this.m_5720_(), 1.0f, 1.0f);
        }
    }

    public float getSpeedMultiplier() {
        return this.getEntityDataValue(DATA_SPEED_MULTIPLIER).floatValue();
    }

    public void setSpeedMultiplier(float speedMultiplier) {
        this.setEntityDataValue(DATA_SPEED_MULTIPLIER, Float.valueOf(speedMultiplier));
    }

    private void handleHealthRegeneration() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.m_21223_() < this.m_21233_()) {
            boolean isAtCloudLevel = this.m_20186_() >= 195.0;
            boolean isRainingOrSnowing = this.f_19853_.m_46471_();
            if (isAtCloudLevel || isRainingOrSnowing) {
                ++this.regenCounter;
                if (this.regenCounter >= 50) {
                    this.m_5634_(1.0f);
                    this.regenCounter = 0;
                    if (this.f_19797_ % 10 == 0) {
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    }
                }
            }
        } else {
            this.regenCounter = 0;
        }
    }
}

