/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.goals.GhastlingFollowPlayerWithSnowballGoal;
import dev.nweaver.happyghastmod.entity.goals.GhastlingLookGoal;
import dev.nweaver.happyghastmod.entity.goals.GhastlingRandomFloatGoal;
import dev.nweaver.happyghastmod.init.EntityInit;
import dev.nweaver.happyghastmod.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Ghastling
extends Ghast {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TRANSFORM_TIME = 24000;
    private static final int FEED_TRANSFORM_BOOST = 1200;
    private static final int PARTICLE_COUNT = 5;
    private static final double GHASTLING_MAX_LEASH_DISTANCE = 5.0;
    private static final double GHASTLING_MAX_LEASH_DISTANCE_SQR = 25.0;
    private static final double GHASTLING_COMFORT_ZONE_RATIO = 0.8;
    private static final double GHASTLING_COMFORT_ZONE_SQR = 20.0;
    private static final double GHASTLING_LEASH_PULL_STRENGTH = 0.06;
    private static final double GHASTLING_LEASH_VERTICAL_PULL_STRENGTH = 0.04;
    private static final double GHASTLING_MOTION_DAMPING = 0.92;
    private static final double GHASTLING_VERTICAL_DAMPING = 0.95;
    private static final double GHASTLING_PULL_FORCE_SMOOTHING = 0.2;
    private Vec3 smoothedPullForce = Vec3.f_82478_;
    private static final double MAX_LEASHED_SPEED = 0.45;
    public static final int MIN_HEIGHT_ABOVE_GROUND = 1;
    public static final int MAX_HEIGHT_ABOVE_GROUND = 2;
    private boolean anchorInitialized = false;
    private static final EntityDataAccessor<Integer> DATA_TRANSFORM_PROGRESS = SynchedEntityData.m_135353_(Ghastling.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Ghastling(EntityType<? extends Ghast> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 1;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TRANSFORM_PROGRESS, (Object)0);
    }

    public int getTransformProgress() {
        return (Integer)this.f_19804_.m_135370_(DATA_TRANSFORM_PROGRESS);
    }

    public void setTransformProgress(int progress) {
        this.f_19804_.m_135381_(DATA_TRANSFORM_PROGRESS, (Object)progress);
    }

    public int getGroundHeight() {
        int entityX = Mth.m_14107_((double)this.m_20185_());
        int entityZ = Mth.m_14107_((double)this.m_20189_());
        int startY = Mth.m_14107_((double)this.m_20186_()) - 1;
        int minY = Math.max(0, startY - 20);
        for (int y = startY; y >= minY; --y) {
            VoxelShape collisionShape;
            BlockPos blockPos = new BlockPos(entityX, y, entityZ);
            BlockState blockState = this.f_19853_.m_8055_(blockPos);
            if (blockState.m_60795_() || blockState.m_60767_().m_76332_() || (collisionShape = blockState.m_60812_((BlockGetter)this.f_19853_, blockPos)).m_83281_()) continue;
            return y + 1;
        }
        return -1;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            int currentProgress;
            if (!this.anchorInitialized) {
                AnchorManager.setAnchor((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.anchorInitialized = true;
                LOGGER.debug("Initialized anchor for Ghastling at spawn location: {}, {}, {}", (Object)this.m_20185_(), (Object)this.m_20186_(), (Object)this.m_20189_());
            }
            if ((currentProgress = this.getTransformProgress()) >= 24000) {
                this.transformToHappyGhast();
                return;
            }
            this.setTransformProgress(currentProgress + 1);
            int groundY = this.getGroundHeight();
            if (groundY != -1) {
                double maxAllowedY = groundY + 2;
                if (this.m_20186_() > maxAllowedY) {
                    Vec3 motion = this.m_20184_();
                    double gravityFactor = Math.min(0.08, (this.m_20186_() - maxAllowedY) * 0.02);
                    this.m_20334_(motion.f_82479_, Math.max(motion.f_82480_ - gravityFactor, -0.2), motion.f_82481_);
                }
            }
            if (AnchorManager.hasAnchor((Entity)this)) {
                double dz;
                Vec3 anchor = AnchorManager.getAnchor((Entity)this);
                double maxRadius = AnchorManager.getMaxRadius((Entity)this);
                double dx = this.m_20185_() - anchor.f_82479_;
                double distSquared = dx * dx + (dz = this.m_20189_() - anchor.f_82481_) * dz;
                if (distSquared > maxRadius * maxRadius) {
                    double dist = Math.sqrt(distSquared);
                    double scale = maxRadius / dist;
                    double newX = anchor.f_82479_ + dx * scale;
                    double newZ = anchor.f_82481_ + dz * scale;
                    Vec3 motion = this.m_20184_();
                    double pullStrength = 0.05;
                    double moveX = (newX - this.m_20185_()) * pullStrength;
                    double moveZ = (newZ - this.m_20189_()) * pullStrength;
                    this.m_20334_(motion.f_82479_ + moveX, motion.f_82480_, motion.f_82481_ + moveZ);
                    this.f_19812_ = true;
                }
            }
            if (this.m_21523_()) {
                Entity leashHolder = this.m_21524_();
                if (leashHolder != null && leashHolder.f_19853_ == this.f_19853_) {
                    double distanceSqr = this.m_20280_(leashHolder);
                    Vec3 currentDelta = this.m_20184_();
                    Vec3 dampedDelta = currentDelta.m_82542_(0.92, 0.95, 0.92);
                    if (distanceSqr > 20.0) {
                        Vec3 newDelta;
                        Vec3 currentPos = this.m_20182_();
                        Vec3 holderPos = leashHolder.m_20182_();
                        Vec3 vecToHolder = holderPos.m_82546_(currentPos);
                        double currentDist = Math.sqrt(distanceSqr);
                        double maxDist = Math.sqrt(25.0);
                        double comfortDist = Math.sqrt(20.0);
                        double overshootRatio = Math.min(1.0, (currentDist - comfortDist) / (maxDist - comfortDist));
                        double pullStrengthFactor = overshootRatio * 0.06;
                        Vec3 rawPullForce = vecToHolder.m_82541_().m_82490_(pullStrengthFactor);
                        this.smoothedPullForce = this.smoothedPullForce.m_82490_(0.8).m_82549_(rawPullForce.m_82490_(0.2));
                        double verticalDiff = holderPos.f_82480_ - currentPos.f_82480_;
                        Vec3 extraVerticalForce = Vec3.f_82478_;
                        if (Math.abs(verticalDiff) > 1.0) {
                            double verticalRatio = Math.min(Math.abs(verticalDiff) / 10.0, 1.0);
                            double yPullStrength = verticalRatio * verticalRatio * 0.04;
                            extraVerticalForce = new Vec3(0.0, Math.signum(verticalDiff) * yPullStrength, 0.0);
                        }
                        if ((newDelta = dampedDelta.m_82549_(this.smoothedPullForce).m_82549_(extraVerticalForce)).m_82556_() > 0.2025) {
                            newDelta = newDelta.m_82541_().m_82490_(0.45);
                        }
                        this.m_20256_(newDelta);
                        this.f_19812_ = true;
                    } else {
                        this.m_20256_(dampedDelta);
                        this.smoothedPullForce = this.smoothedPullForce.m_82556_() > 1.0E-6 ? this.smoothedPullForce.m_82490_(0.8) : Vec3.f_82478_;
                    }
                } else {
                    this.smoothedPullForce = Vec3.f_82478_;
                    if (leashHolder == null || leashHolder.m_213877_()) {
                        this.m_21455_(true, true);
                    }
                }
            } else {
                this.smoothedPullForce = Vec3.f_82478_;
            }
            this.handleWaterAvoidance();
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Level level = this.f_19853_;
        if (itemstack.m_150930_(Items.f_42452_)) {
            if (!level.f_46443_) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                this.m_5634_(1.5f);
                int currentProgress = this.getTransformProgress();
                this.setTransformProgress(Math.min(currentProgress + 1200, 24000));
                this.spawnGreenParticles();
                if (this.getTransformProgress() >= 24000) {
                    this.transformToHappyGhast();
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (itemstack.m_150930_(Items.f_42655_)) {
            if (!level.f_46443_ && this.m_6573_(player)) {
                this.m_21463_((Entity)player, true);
                this.m_146852_(GameEvent.f_223708_, (Entity)player);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                level.m_6269_(null, (Entity)this, SoundEvents.f_12087_, SoundSource.NEUTRAL, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_();
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(this.m_20206_() * 0.5f), 0.0);
    }

    private void spawnGreenParticles() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double d0 = this.m_20191_().m_82399_().f_82479_;
            double d1 = this.m_20191_().m_82399_().f_82480_;
            double d2 = this.m_20191_().m_82399_().f_82481_;
            for (int i = 0; i < 5; ++i) {
                double offsetX = this.f_19796_.m_188583_() * 0.8;
                double offsetY = this.f_19796_.m_188583_() * 0.8;
                double offsetZ = this.f_19796_.m_188583_() * 0.8;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, d0 + offsetX, d1 + offsetY, d2 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void transformToHappyGhast() {
        if (this.f_19853_.f_46443_ || this.m_213877_()) {
            return;
        }
        HappyGhast happyGhast = (HappyGhast)((EntityType)EntityInit.HAPPY_GHAST.get()).m_20615_(this.f_19853_);
        if (happyGhast != null) {
            if (this.m_21523_()) {
                this.m_21455_(true, true);
            }
            happyGhast.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            if (this.m_8077_()) {
                happyGhast.m_6593_(this.m_7770_());
            }
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12275_, SoundSource.HOSTILE, 1.0f, 1.0f);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 30; ++i) {
                    double offsetX = this.f_19796_.m_188583_() * 1.2;
                    double offsetY = this.f_19796_.m_188583_() * 1.2;
                    double offsetZ = this.f_19796_.m_188583_() * 1.2;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            this.f_19853_.m_7967_((Entity)happyGhast);
            this.m_146870_();
        }
    }

    public void m_7380_(CompoundTag c) {
        super.m_7380_(c);
        c.m_128405_("TransformProgress", this.getTransformProgress());
        c.m_128379_("AnchorInitialized", this.anchorInitialized);
    }

    public void m_7378_(CompoundTag c) {
        super.m_7378_(c);
        if (c.m_128441_("TransformProgress")) {
            this.setTransformProgress(c.m_128451_("TransformProgress"));
        }
        this.anchorInitialized = c.m_128471_("AnchorInitialized");
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new GhastlingFollowPlayerWithSnowballGoal(this, 1.0, 30.0f));
        this.f_21345_.m_25352_(5, (Goal)new GhastlingRandomFloatGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new GhastlingLookGoal(this));
    }

    public static AttributeSupplier.Builder m_32752_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_32758_(boolean charging) {
        super.m_32758_(false);
    }

    protected boolean m_8028_() {
        return false;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.f_19853_.f_46443_ || !this.m_21523_() || reason != Entity.RemovalReason.DISCARDED) {
            // empty if block
        }
        super.m_142687_(reason);
    }

    public void m_21455_(boolean broadcastPacket, boolean dropLeashItem) {
        this.smoothedPullForce = Vec3.f_82478_;
        super.m_21455_(broadcastPacket, dropLeashItem);
    }

    public boolean m_21532_() {
        return true;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.GHASTLING_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.GHASTLING_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.GHASTLING_DEATH.get();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.GHASTLING_SPAWN.get(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
    }

    private void handleWaterAvoidance() {
        double distanceToWater;
        BlockPos currentPos;
        boolean inWater;
        if (this.f_19853_.f_46443_) {
            return;
        }
        int entityX = Mth.m_14107_((double)this.m_20185_());
        int entityZ = Mth.m_14107_((double)this.m_20189_());
        int entityY = Mth.m_14107_((double)(this.m_20186_() - 0.2));
        boolean waterBelow = false;
        int waterSurfaceY = -1;
        for (int y = entityY; y > entityY - 5 && y > 0; --y) {
            BlockPos blockPos = new BlockPos(entityX, y, entityZ);
            FluidState fluidState = this.f_19853_.m_6425_(blockPos);
            if (!fluidState.m_76178_() && fluidState.m_205070_(FluidTags.f_13131_)) {
                waterBelow = true;
                waterSurfaceY = y + 1;
                break;
            }
            if (!this.f_19853_.m_8055_(blockPos).m_60795_()) break;
        }
        if (inWater = this.f_19853_.m_6425_(currentPos = this.m_20183_()).m_205070_(FluidTags.f_13131_)) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, Math.max(0.1, motion.f_82480_ + 0.08), motion.f_82481_);
            this.f_19812_ = true;
        } else if (waterBelow && waterSurfaceY != -1 && (distanceToWater = this.m_20186_() - (double)waterSurfaceY) < 2.0) {
            double repulsionForce = Math.max(0.02, 0.05 * (2.0 - distanceToWater));
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, Math.max(0.0, motion.f_82480_ + repulsionForce), motion.f_82481_);
            this.f_19812_ = true;
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20069_()) {
            travelVector = new Vec3(travelVector.f_82479_, Math.max(0.05, travelVector.f_82480_ + 0.05), travelVector.f_82481_);
        }
        super.m_7023_(travelVector);
        if (this.m_20069_()) {
            this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.05, 0.0));
        }
    }

    public boolean isPositionSafeForMovement(double x, double y, double z) {
        BlockPos targetPos = new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        return !this.f_19853_.m_6425_(targetPos).m_205070_(FluidTags.f_13131_);
    }
}

