/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.init.EntityInit;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class GhastPlatformEntity
extends Entity {
    public static final EntityDimensions FIXED_DIMENSIONS = EntityDimensions.m_20395_((float)4.0f, (float)0.5f);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(GhastPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public GhastPlatformEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public GhastPlatformEntity(Level level, double x, double y, double z, HappyGhast owner) {
        this((EntityType)EntityInit.GHAST_PLATFORM.get(), level);
        this.m_6034_(x, y, z);
        this.setOwnerUUID(owner.m_20148_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    public void m_7334_(Entity pEntity) {
    }

    public void m_142687_(Entity.RemovalReason reason) {
        System.out.println("GhastPlatformEntity " + String.valueOf(this.m_20148_()) + " is being removed by the engine. Reason: " + String.valueOf(reason));
        super.m_142687_(reason);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.getOwnerUUID().isPresent()) {
            Entity owner = null;
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                owner = serverLevel.m_8791_(this.getOwnerUUID().get());
            }
            if (owner == null || !owner.m_6084_()) {
                System.out.println("Owner Ghast not found or dead, removing platform " + String.valueOf(this.m_20148_()));
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
        this.m_20256_(Vec3.f_82478_);
        if (this.f_19797_ > 1) {
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
        }
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.f_19804_.m_135370_(OWNER_UUID);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public HappyGhast getOwner() {
        try {
            ServerLevel serverLevel;
            Entity entity;
            Level level;
            UUID uuid = this.getOwnerUUID().orElse(null);
            if (uuid != null && (level = this.f_19853_) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(uuid)) instanceof HappyGhast) {
                return (HappyGhast)entity;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return !this.m_213877_();
    }

    protected void m_5841_() {
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        if (this.m_6095_() != null) {
            AABB aabb = this.m_6095_().m_20680_().m_20384_(x, y, z);
            this.m_20011_(aabb);
        } else {
            this.m_20011_(FIXED_DIMENSIONS.m_20384_(x, y, z));
        }
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("Owner")) {
            this.setOwnerUUID(compound.m_128342_("Owner"));
        } else {
            this.setOwnerUUID(null);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        this.getOwnerUUID().ifPresent(uuid -> compound.m_128362_("Owner", uuid));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

