/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity;

import dev.nweaver.happyghastmod.entity.Ghastling;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnchorManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<UUID, Vec3> anchors = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Long> followingTimestamps = new HashMap<UUID, Long>();
    private static final Map<UUID, Vec3> lastPlayerPositions = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Vec3> movementVectors = new HashMap<UUID, Vec3>();
    private static final long FOLLOWING_TIMEOUT = 3000L;
    private static final double MAX_HEIGHT_OFFSET = 16.0;
    private static final double MIN_HEIGHT_OFFSET = -8.0;
    private static final Map<UUID, Long> lastAnchorUpdateTime = new HashMap<UUID, Long>();
    private static final long ANCHOR_UPDATE_COOLDOWN = 3000L;

    public static void setAnchor(Entity entity, double x, double y, double z) {
        anchors.put(entity.m_20148_(), new Vec3(x, y, z));
        LOGGER.debug("Set anchor for entity {} at {}, {}, {}", (Object)entity.m_20148_(), (Object)x, (Object)y, (Object)z);
    }

    public static boolean setAnchorWithCooldown(Entity entity, double x, double y, double z) {
        UUID entityId = entity.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastUpdate = lastAnchorUpdateTime.get(entityId);
        if (lastUpdate != null && currentTime - lastUpdate < 3000L) {
            return false;
        }
        AnchorManager.setAnchor(entity, x, y, z);
        lastAnchorUpdateTime.put(entityId, currentTime);
        return true;
    }

    public static boolean canUpdateAnchor(Entity entity) {
        UUID entityId = entity.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastUpdate = lastAnchorUpdateTime.get(entityId);
        return lastUpdate == null || currentTime - lastUpdate >= 3000L;
    }

    public static boolean hasAnchor(Entity entity) {
        return anchors.containsKey(entity.m_20148_());
    }

    public static Vec3 getAnchor(Entity entity) {
        return anchors.get(entity.m_20148_());
    }

    public static void removeAnchor(Entity entity) {
        anchors.remove(entity.m_20148_());
    }

    public static void markAsFollowing(Entity entity) {
        followingTimestamps.put(entity.m_20148_(), System.currentTimeMillis());
    }

    public static void stopFollowing(Entity entity) {
        followingTimestamps.remove(entity.m_20148_());
        if (entity.m_20184_().m_82556_() > 0.01) {
            movementVectors.put(entity.m_20148_(), entity.m_20184_());
        }
    }

    public static boolean isFollowing(Entity entity) {
        Long timestamp = followingTimestamps.get(entity.m_20148_());
        if (timestamp == null) {
            return false;
        }
        return System.currentTimeMillis() - timestamp < 3000L;
    }

    public static void updateLastPlayerPosition(Entity entity, double x, double y, double z) {
        lastPlayerPositions.put(entity.m_20148_(), new Vec3(x, y, z));
    }

    public static Vec3 getLastPlayerPosition(Entity entity) {
        return lastPlayerPositions.get(entity.m_20148_());
    }

    public static double getMaxRadius(Entity entity) {
        if (AnchorManager.isFollowing(entity)) {
            return 64.0;
        }
        if (entity instanceof Ghastling) {
            return 32.0;
        }
        if (entity instanceof HappyGhast) {
            HappyGhast happyGhast = (HappyGhast)entity;
            return happyGhast.isSaddled() ? 32.0 : 64.0;
        }
        return 64.0;
    }

    public static double getMaxHeightOffset() {
        return 16.0;
    }

    public static double getMinHeightOffset() {
        return -8.0;
    }

    public static double constrainHeight(Entity entity, double y) {
        Ghastling ghastling;
        int groundY;
        if (!AnchorManager.hasAnchor(entity)) {
            return y;
        }
        if (entity instanceof Ghastling && (groundY = (ghastling = (Ghastling)entity).getGroundHeight()) != -1) {
            double maxY = groundY + 2;
            double minY = groundY + 1;
            double minHeightAboveGround = Math.max(minY, (double)(entity.f_19853_.m_5736_() + 2));
            return Math.max(minHeightAboveGround, Math.min(y, maxY));
        }
        if (AnchorManager.isFollowing(entity)) {
            double minHeightAboveGround = entity.f_19853_.m_5736_() + 5;
            return Math.max(minHeightAboveGround, y);
        }
        Vec3 anchor = AnchorManager.getAnchor(entity);
        double maxY = anchor.f_82480_ + 16.0;
        double minY = anchor.f_82480_ + -8.0;
        double minHeightAboveGround = entity.f_19853_.m_5736_() + 5;
        minY = Math.max(minY, minHeightAboveGround);
        return Math.max(minY, Math.min(y, maxY));
    }

    public static boolean isWithinAllowedRadius(Entity entity, double x, double y, double z) {
        if (AnchorManager.isFollowing(entity)) {
            return true;
        }
        if (!AnchorManager.hasAnchor(entity)) {
            return true;
        }
        Vec3 anchor = AnchorManager.getAnchor(entity);
        double maxRadius = AnchorManager.getMaxRadius(entity);
        double dx = x - anchor.f_82479_;
        double dz = z - anchor.f_82481_;
        double horizontalDistSq = dx * dx + dz * dz;
        double dy = y - anchor.f_82480_;
        boolean withinHorizontalRadius = horizontalDistSq <= maxRadius * maxRadius;
        boolean withinVerticalRange = dy >= -8.0 && dy <= 16.0;
        return withinHorizontalRadius && withinVerticalRange;
    }

    public static boolean createTemporaryAnchor(Entity entity, double playerX, double playerY, double playerZ) {
        if (!AnchorManager.canUpdateAnchor(entity)) {
            return false;
        }
        if (!AnchorManager.hasAnchor(entity)) {
            return AnchorManager.setAnchorWithCooldown(entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        }
        Vec3 anchor = AnchorManager.getAnchor(entity);
        double dx = playerX - anchor.f_82479_;
        double dz = playerZ - anchor.f_82481_;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        if (horizontalDist < AnchorManager.getMaxRadius(entity) * 0.7) {
            return false;
        }
        double scale = 0.3;
        double newX = anchor.f_82479_ + dx * scale;
        double newY = anchor.f_82480_;
        double newZ = anchor.f_82481_ + dz * scale;
        boolean updated = AnchorManager.setAnchorWithCooldown(entity, newX, newY, newZ);
        if (updated) {
            LOGGER.debug("Created temporary anchor at {}, {}, {}", (Object)newX, (Object)newY, (Object)newZ);
        }
        return updated;
    }

    public static Vec3 getDecelerationVector(Entity entity) {
        Vec3 vector = movementVectors.get(entity.m_20148_());
        if (vector == null) {
            return Vec3.f_82478_;
        }
        double deceleration = 0.8;
        Vec3 newVector = vector.m_82490_(deceleration);
        if (newVector.m_82556_() < 0.001) {
            movementVectors.remove(entity.m_20148_());
            return Vec3.f_82478_;
        }
        movementVectors.put(entity.m_20148_(), newVector);
        return newVector;
    }
}

