/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.nweaver.happyghastmod.init.ItemInit;
import dev.nweaver.happyghastmod.item.HarnessItem;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import dev.nweaver.happyghastmod.network.SyncCustomHarnessPacket;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="happyghastmod")
public class CustomHarnessManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CUSTOM_HARNESSES_DIR = "happyghastmod/custom_harnesses";
    private static final String REGISTRY_FILE = "registry.json";
    private static final Map<String, CustomHarnessData> registeredHarnesses = new HashMap<String, CustomHarnessData>();

    public static boolean isSinglePlayerServer(MinecraftServer server) {
        return server != null && server.m_129792_();
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        if (CustomHarnessManager.isSinglePlayerServer(event.getServer())) {
            CustomHarnessManager.loadRegistry();
        } else {
            LOGGER.info("Custom harnesses are currently disabled in multiplayer. They will be loaded in single-player only.");
        }
    }

    public static boolean registerCustomHarness(String harnessId, String harnessName, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData, ServerPlayer player) {
        try {
            if (!CustomHarnessManager.isSinglePlayerServer(player.m_20194_())) {
                LOGGER.info("Custom harnesses are currently disabled in multiplayer. Player {} attempted to create a harness.", (Object)player.m_7755_().getString());
                return false;
            }
            Path baseDir = FMLPaths.GAMEDIR.get().resolve(CUSTOM_HARNESSES_DIR);
            Path harnessDir = baseDir.resolve(harnessId);
            Files.createDirectories(harnessDir, new FileAttribute[0]);
            boolean hasSaddleTexture = false;
            boolean hasGlassesTexture = false;
            boolean hasAccessoryTexture = false;
            if (saddleTextureData != null) {
                Files.write(harnessDir.resolve("saddle.png"), saddleTextureData, new OpenOption[0]);
                hasSaddleTexture = true;
            }
            if (glassesTextureData != null) {
                Files.write(harnessDir.resolve("glasses.png"), glassesTextureData, new OpenOption[0]);
                hasGlassesTexture = true;
            }
            if (accessoryTextureData != null) {
                Files.write(harnessDir.resolve("accessory.png"), accessoryTextureData, new OpenOption[0]);
                hasAccessoryTexture = true;
            }
            CustomHarnessData data = new CustomHarnessData(harnessId, harnessName, player.m_20149_(), player.m_7755_().getString(), hasSaddleTexture, hasGlassesTexture, hasAccessoryTexture);
            registeredHarnesses.put(harnessId, data);
            CustomHarnessManager.saveRegistry();
            CustomHarnessManager.syncCustomHarnessToAllPlayers(data, saddleTextureData, glassesTextureData, accessoryTextureData);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u0443\u044e \u0441\u0431\u0440\u0443\u044e: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static void syncAllHarnessesToPlayer(ServerPlayer player) {
        if (!CustomHarnessManager.isSinglePlayerServer(player.m_20194_())) {
            LOGGER.debug("Skipping custom harness sync in multiplayer for player {}", (Object)player.m_7755_().getString());
            return;
        }
        for (Map.Entry<String, CustomHarnessData> entry : registeredHarnesses.entrySet()) {
            String harnessId = entry.getKey();
            CustomHarnessData data = entry.getValue();
            byte[] saddleTextureData = CustomHarnessManager.loadCustomHarnessTexture(harnessId, "saddle");
            byte[] glassesTextureData = CustomHarnessManager.loadCustomHarnessTexture(harnessId, "glasses");
            byte[] accessoryTextureData = CustomHarnessManager.loadCustomHarnessTexture(harnessId, "accessory");
            SyncCustomHarnessPacket packet = new SyncCustomHarnessPacket(data.getId(), data.getName(), data.getCreatorName(), saddleTextureData, glassesTextureData, accessoryTextureData);
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && CustomHarnessManager.isSinglePlayerServer((player = (ServerPlayer)player2).m_20194_())) {
            CustomHarnessManager.syncAllHarnessesToPlayer(player);
        }
    }

    public static void giveCustomHarnessToPlayer(String harnessId, ServerPlayer player) {
        if (!CustomHarnessManager.isSinglePlayerServer(player.m_20194_())) {
            LOGGER.info("Cannot give custom harness in multiplayer to player {}", (Object)player.m_7755_().getString());
            return;
        }
        CustomHarnessData data = registeredHarnesses.get(harnessId);
        if (data == null) {
            LOGGER.error("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u044b\u0434\u0430\u0442\u044c \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0441\u0431\u0440\u0443\u044e \u0441 ID {}", (Object)harnessId);
            return;
        }
        Item baseItem = null;
        for (RegistryObject<HarnessItem> harnessRegObj : ItemInit.HARNESS_ITEMS.values()) {
            Item item = (Item)harnessRegObj.get();
            if (!(item instanceof HarnessItem)) continue;
            baseItem = item;
            break;
        }
        if (baseItem == null) {
            LOGGER.error("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0441\u0431\u0440\u0443\u0438 \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0439 \u0441\u0431\u0440\u0443\u0438");
            return;
        }
        ItemStack stack = new ItemStack(baseItem);
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("CustomHarnessId", harnessId);
        tag.m_128359_("CustomHarnessName", data.getName());
        if (data.hasSaddleTexture()) {
            tag.m_128379_("HasCustomSaddleTexture", true);
        }
        if (data.hasGlassesTexture()) {
            tag.m_128379_("HasCustomGlassesTexture", true);
        }
        if (data.hasAccessoryTexture()) {
            tag.m_128379_("HasCustomAccessoryTexture", true);
        }
        CompoundTag display = new CompoundTag();
        display.m_128359_("Name", "{\"text\":\"" + data.getName() + "\",\"italic\":false}");
        tag.m_128365_("display", (Tag)display);
        player.m_150109_().m_36054_(stack);
    }

    private static void loadRegistry() {
        registeredHarnesses.clear();
        File registryFile = FMLPaths.GAMEDIR.get().resolve(CUSTOM_HARNESSES_DIR).resolve(REGISTRY_FILE).toFile();
        if (!registryFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(registryFile);){
            JsonObject registry = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            registry.entrySet().forEach(entry -> {
                String id = (String)entry.getKey();
                JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                CustomHarnessData data = new CustomHarnessData(id, obj.get("name").getAsString(), obj.get("creatorUuid").getAsString(), obj.get("creatorName").getAsString(), obj.get("hasSaddleTexture").getAsBoolean(), obj.get("hasGlassesTexture").getAsBoolean(), obj.get("hasAccessoryTexture").getAsBoolean());
                registeredHarnesses.put(id, data);
            });
        }
        catch (Exception e) {
            LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0440\u0435\u0435\u0441\u0442\u0440 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0441\u0431\u0440\u0443\u0439: {}", (Object)e.getMessage());
        }
    }

    private static void saveRegistry() {
        File registryFile = FMLPaths.GAMEDIR.get().resolve(CUSTOM_HARNESSES_DIR).resolve(REGISTRY_FILE).toFile();
        try {
            if (!registryFile.getParentFile().exists()) {
                registryFile.getParentFile().mkdirs();
            }
            JsonObject registry = new JsonObject();
            for (Map.Entry<String, CustomHarnessData> entry : registeredHarnesses.entrySet()) {
                JsonObject obj = new JsonObject();
                CustomHarnessData data = entry.getValue();
                obj.addProperty("name", data.getName());
                obj.addProperty("creatorUuid", data.getCreatorUuid());
                obj.addProperty("creatorName", data.getCreatorName());
                obj.addProperty("hasSaddleTexture", Boolean.valueOf(data.hasSaddleTexture()));
                obj.addProperty("hasGlassesTexture", Boolean.valueOf(data.hasGlassesTexture()));
                obj.addProperty("hasAccessoryTexture", Boolean.valueOf(data.hasAccessoryTexture()));
                registry.add(entry.getKey(), (JsonElement)obj);
            }
            try (FileWriter writer = new FileWriter(registryFile);){
                GSON.toJson((JsonElement)registry, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0440\u0435\u0435\u0441\u0442\u0440 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0441\u0431\u0440\u0443\u0439: {}", (Object)e.getMessage());
        }
    }

    private static void syncCustomHarnessToAllPlayers(CustomHarnessData data, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData) {
        SyncCustomHarnessPacket packet = new SyncCustomHarnessPacket(data.getId(), data.getName(), data.getCreatorName(), saddleTextureData, glassesTextureData, accessoryTextureData);
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static CustomHarnessData getCustomHarnessData(String id) {
        return registeredHarnesses.get(id);
    }

    public static Map<String, CustomHarnessData> getAllCustomHarnesses() {
        return new HashMap<String, CustomHarnessData>(registeredHarnesses);
    }

    public static byte[] loadCustomHarnessTexture(String harnessId, String textureType) {
        if ("item".equals(textureType)) {
            LOGGER.warn("Attempted to load 'item' texture for custom harness {}, which is not supported.", (Object)harnessId);
            return null;
        }
        Path path = FMLPaths.GAMEDIR.get().resolve(CUSTOM_HARNESSES_DIR).resolve(harnessId).resolve(textureType + ".png");
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u0443 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0439 \u0441\u0431\u0440\u0443\u0438: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static class CustomHarnessData {
        private final String id;
        private final String name;
        private final String creatorUuid;
        private final String creatorName;
        private final boolean hasSaddleTexture;
        private final boolean hasGlassesTexture;
        private final boolean hasAccessoryTexture;

        public CustomHarnessData(String id, String name, String creatorUuid, String creatorName, boolean hasSaddleTexture, boolean hasGlassesTexture, boolean hasAccessoryTexture) {
            this.id = id;
            this.name = name;
            this.creatorUuid = creatorUuid;
            this.creatorName = creatorName;
            this.hasSaddleTexture = hasSaddleTexture;
            this.hasGlassesTexture = hasGlassesTexture;
            this.hasAccessoryTexture = hasAccessoryTexture;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getCreatorUuid() {
            return this.creatorUuid;
        }

        public String getCreatorName() {
            return this.creatorName;
        }

        public boolean hasSaddleTexture() {
            return this.hasSaddleTexture;
        }

        public boolean hasGlassesTexture() {
            return this.hasGlassesTexture;
        }

        public boolean hasAccessoryTexture() {
            return this.hasAccessoryTexture;
        }
    }
}

