/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.container;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.init.ContainerInit;
import dev.nweaver.happyghastmod.item.HarnessItem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastContainer
extends AbstractContainerMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Container ghastContainer;
    @Nullable
    public final HappyGhast ghast;

    public static GhastContainer create(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        HappyGhast foundGhast = null;
        Object container = null;
        if (data != null && data.readableBytes() >= 4) {
            try {
                int entityId = data.readInt();
                if (Minecraft.m_91087_().f_91073_ != null) {
                    Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(entityId);
                    if (entity instanceof HappyGhast) {
                        HappyGhast happyGhast = (HappyGhast)entity;
                        foundGhast = happyGhast;
                        if (foundGhast.getInventoryComponent() != null) {
                            container = foundGhast.getInventoryComponent();
                        }
                    } else if (entity != null) {
                        LOGGER.error("Entity with ID {} is not a HappyGhast", (Object)entityId);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while reading ghast ID from buffer", (Throwable)e);
            }
        }
        if (container == null) {
            container = new SimpleContainer(1);
        }
        return new GhastContainer(windowId, playerInventory, (Container)container, foundGhast);
    }

    public GhastContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(1), null);
    }

    public GhastContainer(int id, Inventory playerInventory, Container ghastContainer, @Nullable HappyGhast ghast) {
        super((MenuType)ContainerInit.GHAST_CONTAINER.get(), id);
        this.ghastContainer = ghastContainer;
        this.ghast = ghast;
        this.m_38897_(new HarnessSlot(this.ghastContainer, 0, 8, 18));
        this.addPlayerInventorySlots(playerInventory);
    }

    private void addPlayerInventorySlots(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return this.ghast != null && this.ghast.m_6084_() && (this.ghast.m_20363_((Entity)player) || (double)player.m_20270_((Entity)this.ghast) < 8.0);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            result = slotStack.m_41777_();
            if (index < this.ghastContainer.m_6643_()) {
                if (!this.m_38903_(slotStack, this.ghastContainer.m_6643_(), this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.m_38853_(0).m_5857_(slotStack)) {
                if (!this.m_38903_(slotStack, 0, this.ghastContainer.m_6643_(), false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return result;
    }

    private class HarnessSlot
    extends Slot {
        public HarnessSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41720_() instanceof HarnessItem;
        }

        public int m_6641_() {
            return 1;
        }
    }
}

