/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ListHappyGhastsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"happyghast").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(context -> ListHappyGhastsCommand.listGhasts((CommandSourceStack)context.getSource(), 30))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> ListHappyGhastsCommand.listGhasts((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"))))));
    }

    private static int listGhasts(CommandSourceStack source, int radius) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof Player)) {
            source.m_81352_((Component)Component.m_237113_((String)"\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c\u0441\u044f \u0438\u0433\u0440\u043e\u043a\u043e\u043c"));
            return 0;
        }
        Player player = (Player)entity;
        ServerLevel level = source.m_81372_();
        Vec3 pos = player.m_20182_();
        AABB searchArea = new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - (double)radius, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)radius, pos.f_82481_ + (double)radius);
        List ghasts = level.m_45976_(HappyGhast.class, searchArea);
        if (ghasts.isEmpty()) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.happyghast.list.no_ghasts", (Object[])new Object[]{radius}), false);
            return 0;
        }
        ghasts.sort((g1, g2) -> {
            double dist1 = g1.m_20280_((Entity)player);
            double dist2 = g2.m_20280_((Entity)player);
            return Double.compare(dist1, dist2);
        });
        source.m_81354_((Component)Component.m_237110_((String)"commands.happyghast.list.header", (Object[])new Object[]{ghasts.size()}), false);
        for (HappyGhast ghast : ghasts) {
            double distance = Math.sqrt(ghast.m_20280_((Entity)player));
            MutableComponent saddleComponent = ghast.isSaddled() ? Component.m_237115_((String)"commands.happyghast.list.with_saddle").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"commands.happyghast.list.without_saddle").m_130940_(ChatFormatting.RED);
            String posString = String.format("%.1f, %.1f, %.1f", ghast.m_20185_(), ghast.m_20186_(), ghast.m_20189_());
            String distString = String.format("%.1f", distance);
            MutableComponent posComponent = Component.m_237113_((String)("[" + posString + "]")).m_130940_(ChatFormatting.GRAY);
            MutableComponent distComponent = Component.m_237110_((String)"commands.happyghast.list.distance", (Object[])new Object[]{distString}).m_130940_(ChatFormatting.GRAY);
            String uuidString = ghast.m_20148_().toString();
            MutableComponent uuidComponent = Component.m_237113_((String)uuidString).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuidString)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.happyghast.list.click_to_copy"))));
            MutableComponent addMobButton = Component.m_237113_((String)" [+]").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/happyghast addmob " + uuidString + " zombie")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.happyghast.list.add_mob"))));
            MutableComponent line = Component.m_237113_((String)"").m_7220_((Component)posComponent).m_130946_(" ").m_7220_((Component)distComponent).m_130946_(" ").m_7220_((Component)saddleComponent).m_130946_(" UUID: ").m_7220_((Component)uuidComponent).m_7220_((Component)addMobButton);
            source.m_81354_((Component)line, false);
        }
        return ghasts.size();
    }
}

