/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.nweaver.happyghastmod.custom.CustomHarnessManager;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import dev.nweaver.happyghastmod.network.OpenHarnessCreatorPacket;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HarnessCreatorCommand {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ghast").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"createharness").requires(source -> {
            if (!source.m_6761_(2)) {
                return false;
            }
            if (source.m_81377_() != null && !CustomHarnessManager.isSinglePlayerServer(source.m_81377_())) {
                if (source.m_81373_() instanceof ServerPlayer) {
                    source.m_81352_((Component)Component.m_237113_((String)"Custom harness creation is currently only available in single-player mode."));
                }
                return false;
            }
            return true;
        })).executes(HarnessCreatorCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be used by players"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!CustomHarnessManager.isSinglePlayerServer(source.m_81377_())) {
            source.m_81352_((Component)Component.m_237113_((String)"Custom harness creation is currently only available in single-player mode."));
            return 0;
        }
        boolean isSinglePlayer = source.m_81377_().m_129792_();
        OpenHarnessCreatorPacket packet = new OpenHarnessCreatorPacket(isSinglePlayer);
        NetworkHandler.sendToPlayer(packet, player);
        LOGGER.debug("Sent open harness creator packet to player {}", (Object)player.m_7755_().getString());
        return 1;
    }
}

