/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastMovementComponent;
import dev.nweaver.happyghastmod.network.GhastSpeedSyncPacket;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastSpeedCommand {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final float DEFAULT_SPEED = 1.0f;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ghastspeed").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"multiplier", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)10.0f)).executes(context -> GhastSpeedCommand.setGhastSpeed((CommandContext<CommandSourceStack>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"multiplier"))))).then(Commands.m_82127_((String)"reset").executes(context -> GhastSpeedCommand.setGhastSpeed((CommandContext<CommandSourceStack>)context, 1.0f)))).executes(context -> {
            float currentMultiplier = GhastMovementComponent.SPEED_MULTIPLIER;
            String statusText = GhastSpeedCommand.formatSpeedStatus(currentMultiplier);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)statusText), false);
            return 1;
        }));
        LOGGER.info("GhastSpeedCommand registered");
    }

    private static String formatSpeedStatus(float multiplier) {
        StringBuilder status = new StringBuilder();
        status.append(String.format("Current Happy Ghast speed multiplier: %.1f", Float.valueOf(multiplier)));
        if (multiplier == 1.0f) {
            status.append(" (standard speed)");
        } else if (multiplier < 1.0f) {
            status.append(String.format(" (%.1f\u00d7 slower than standard)", Float.valueOf(1.0f / multiplier)));
        } else {
            status.append(String.format(" (%.1f\u00d7 faster than standard)", Float.valueOf(multiplier / 1.0f)));
        }
        return status.toString();
    }

    private static int setGhastSpeed(CommandContext<CommandSourceStack> context, float multiplier) {
        String message;
        float oldMultiplier = GhastMovementComponent.SPEED_MULTIPLIER;
        GhastMovementComponent.SPEED_MULTIPLIER = multiplier;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (source.m_81377_() != null) {
            for (ServerLevel level : source.m_81377_().m_129785_()) {
                for (Entity entity : level.m_8583_()) {
                    if (!(entity instanceof HappyGhast)) continue;
                    HappyGhast happyGhast = (HappyGhast)entity;
                    happyGhast.setSpeedMultiplier(multiplier);
                }
            }
        }
        if (multiplier == 1.0f && oldMultiplier == 1.0f) {
            message = "Happy Ghast speed multiplier remained standard (1.0)";
        } else if (multiplier == 1.0f) {
            message = "Happy Ghast speed multiplier reset to standard (1.0)";
        } else {
            String comparison = "";
            if (oldMultiplier != multiplier) {
                comparison = multiplier > oldMultiplier ? String.format(" (%.1f\u00d7 faster)", Float.valueOf(multiplier / oldMultiplier)) : String.format(" (%.1f\u00d7 slower)", Float.valueOf(oldMultiplier / multiplier));
            }
            message = String.format("Happy Ghast speed multiplier changed from %.1f to %.1f%s", Float.valueOf(oldMultiplier), Float.valueOf(multiplier), comparison);
        }
        GhastSpeedSyncPacket packet = new GhastSpeedSyncPacket(multiplier);
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)message), true);
        LOGGER.info("{} and broadcasted to all clients", (Object)message);
        return 1;
    }
}

