/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.item.CustomHarnessItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HappyGhastSaddleLayer
extends RenderLayer<Ghast, GhastModel<Ghast>> {
    private static final Logger LOGGER = LogManager.getLogger((String)"HappyGhastMod");
    private static final Map<String, ResourceLocation> SADDLE_TEXTURES = new HashMap<String, ResourceLocation>();
    private static final ResourceLocation BLUE_SADDLE_TEXTURE = HappyGhastMod.rl("textures/entity/ghastsaddleblue.png");
    private final GhastModel<Ghast> model;
    private static final float Y_OFFSET = -0.05f;

    public HappyGhastSaddleLayer(RenderLayerParent<Ghast, GhastModel<Ghast>> parent, GhastModel<Ghast> model) {
        super(parent);
        this.model = model;
    }

    private ResourceLocation getSaddleTexture(String color) {
        if (color == null || color.isEmpty()) {
            return BLUE_SADDLE_TEXTURE;
        }
        if (color.startsWith("custom:")) {
            String harnessId = color.substring(7);
            ResourceLocation customTexture = ClientCustomHarnessManager.getHarnessTexture(harnessId, ClientCustomHarnessManager.TextureType.SADDLE);
            if (customTexture != null) {
                return customTexture;
            }
            return BLUE_SADDLE_TEXTURE;
        }
        return SADDLE_TEXTURES.computeIfAbsent(color, k -> {
            String fileName = "textures/entity/ghastsaddle" + color.replace("_", "") + ".png";
            return HappyGhastMod.rl(fileName);
        });
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Ghast entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        HappyGhast happyGhast;
        if (entity instanceof HappyGhast && (happyGhast = (HappyGhast)entity).isSaddled()) {
            ItemStack saddleItem;
            Object harnessColor = happyGhast.getHarnessColor();
            String customHarnessId = null;
            if (happyGhast.getInventoryComponent() != null && (saddleItem = happyGhast.getInventoryComponent().m_8020_(0)) != null && !saddleItem.m_41619_()) {
                if (saddleItem.m_41720_() instanceof CustomHarnessItem) {
                    customHarnessId = CustomHarnessItem.getCustomHarnessId(saddleItem);
                } else if (saddleItem.m_41782_() && saddleItem.m_41783_().m_128441_("CustomHarnessId")) {
                    customHarnessId = saddleItem.m_41783_().m_128461_("CustomHarnessId");
                }
            }
            if (customHarnessId != null) {
                harnessColor = "custom:" + customHarnessId;
            }
            ResourceLocation textureLocation = this.getSaddleTexture((String)harnessColor);
            ((GhastModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((Entity)entity, limbSwing, limbSwingAmount, partialTick);
            this.model.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            RenderType renderType = RenderType.m_110473_((ResourceLocation)textureLocation);
            VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
            poseStack.m_85836_();
            poseStack.m_85841_(1.05f, 1.05f, 1.05f);
            poseStack.m_85837_(0.0, (double)-0.05f, 0.0);
            this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }
}

