/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ghast;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HappyGhastGlassesLayer
extends RenderLayer<Ghast, GhastModel<Ghast>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GLASSES_TEXTURE = HappyGhastMod.rl("textures/entity/glassestexture.png");
    private static final ResourceLocation PWGOOD_TEXTURE = HappyGhastMod.rl("textures/entity/pwgood_face.png");
    private static final ResourceLocation PWGOODS_TEXTURE = HappyGhastMod.rl("textures/entity/pwgoods_face.png");
    private static final ResourceLocation ACCESSORY_TEXTURE = HappyGhastMod.rl("textures/entity/glasses_accessory.png");
    private final GhastModel<Ghast> model;
    private static final float Y_OFFSET = -0.1f;
    private static final float Z_OFFSET = 0.0f;
    private static final float SCALE = 1.1f;
    private static final float ACCESSORY_Y_OFFSET = -0.0f;
    private static final float ACCESSORY_Z_OFFSET = -0.0f;
    private static final float ACCESSORY_SCALE = 1.055f;
    private static final float RAISED_OFFSET = 0.2f;

    public HappyGhastGlassesLayer(RenderLayerParent<Ghast, GhastModel<Ghast>> parent, GhastModel<Ghast> model) {
        super(parent);
        this.model = model;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Ghast entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        HappyGhast happyGhast;
        if (entity instanceof HappyGhast && (happyGhast = (HappyGhast)entity).isSaddled()) {
            ResourceLocation accessoryTexture;
            boolean isPwGoodType;
            String harnessColor = happyGhast.getHarnessColor();
            String customHarnessId = null;
            if (harnessColor.startsWith("custom:")) {
                customHarnessId = harnessColor.substring(7);
            }
            ResourceLocation glassesTexture = this.determineGlassesTexture(harnessColor, customHarnessId);
            ((GhastModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((Entity)entity, limbSwing, limbSwingAmount, partialTick);
            this.model.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            RenderType renderType = RenderType.m_110473_((ResourceLocation)glassesTexture);
            VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
            poseStack.m_85836_();
            float scale = 1.1f;
            poseStack.m_85841_(scale, scale, scale);
            float offsetX = 0.0f;
            float offsetY = -0.1f;
            float offsetZ = 0.0f;
            float rotX = 0.0f;
            boolean bl = isPwGoodType = "pwgood".equals(harnessColor) || "pwgoods".equals(harnessColor);
            if (!happyGhast.m_20160_() && !isPwGoodType) {
                offsetY += 0.2f;
                rotX = -40.0f;
                offsetZ += 0.52f;
            }
            poseStack.m_85837_((double)offsetX, (double)offsetY, (double)offsetZ);
            if (rotX != 0.0f) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(rotX));
            }
            this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            if (customHarnessId != null && ClientCustomHarnessManager.hasCustomTexture(customHarnessId, ClientCustomHarnessManager.TextureType.ACCESSORY) && (accessoryTexture = ClientCustomHarnessManager.getHarnessTexture(customHarnessId, ClientCustomHarnessManager.TextureType.ACCESSORY)) != null) {
                this.renderAccessory(poseStack, buffer, packedLight, happyGhast, accessoryTexture);
            }
        }
    }

    private ResourceLocation determineGlassesTexture(String harnessColor, String customHarnessId) {
        ResourceLocation customTexture;
        if (customHarnessId != null && (customTexture = ClientCustomHarnessManager.getHarnessTexture(customHarnessId, ClientCustomHarnessManager.TextureType.GLASSES)) != null) {
            return customTexture;
        }
        switch (harnessColor) {
            case "pwgood": {
                return PWGOOD_TEXTURE;
            }
            case "pwgoods": {
                return PWGOODS_TEXTURE;
            }
        }
        return GLASSES_TEXTURE;
    }

    private void renderAccessory(PoseStack poseStack, MultiBufferSource buffer, int packedLight, HappyGhast happyGhast, ResourceLocation textureToUse) {
        RenderType renderType = RenderType.m_110473_((ResourceLocation)textureToUse);
        VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
        poseStack.m_85836_();
        float scale = 1.055f;
        poseStack.m_85841_(scale, scale, scale);
        float offsetX = 0.0f;
        float offsetY = -0.0f;
        float offsetZ = -0.0f;
        poseStack.m_85837_((double)offsetX, (double)offsetY, (double)offsetZ);
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

