/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.client.model.HappyGhastModel;
import dev.nweaver.happyghastmod.client.renderer.layers.HappyGhastGlassesLayer;
import dev.nweaver.happyghastmod.client.renderer.layers.HappyGhastSaddleLayer;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.init.ModelLayersInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Ghast;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HappyGhastRenderer
extends GhastRenderer {
    private static final ResourceLocation TEXTURE = HappyGhastMod.rl("textures/entity/happy_ghast.png");
    private static final Logger LOGGER = LogManager.getLogger(HappyGhastRenderer.class);
    private static int renderLogCounter = 0;
    private static final int LOG_INTERVAL = 50;

    public HappyGhastRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_115290_ = new HappyGhastModel(ctx.m_174023_(ModelLayersInit.HAPPY_GHAST));
        HappyGhastModel<Ghast> saddleModel = new HappyGhastModel<Ghast>(ctx.m_174023_(ModelLayersInit.HAPPY_GHAST));
        this.m_115326_(new HappyGhastSaddleLayer((RenderLayerParent<Ghast, GhastModel<Ghast>>)this, saddleModel));
        HappyGhastModel<Ghast> glassesModel = new HappyGhastModel<Ghast>(ctx.m_174023_(ModelLayersInit.HAPPY_GHAST));
        this.m_115326_(new HappyGhastGlassesLayer((RenderLayerParent<Ghast, GhastModel<Ghast>>)this, glassesModel));
        System.out.println("[HappyGhastMod] HappyGhastRenderer initialized with custom tentacle model!");
    }

    public void render(Ghast entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity instanceof HappyGhast) {
            HappyGhast happyGhast = (HappyGhast)entity;
            float interpolatedYaw = Mth.m_14189_((float)partialTicks, (float)happyGhast.f_19859_, (float)happyGhast.m_146908_());
            float interpolatedPitch = Mth.m_14189_((float)partialTicks, (float)happyGhast.f_19860_, (float)happyGhast.m_146909_());
            float headYaw = Mth.m_14189_((float)partialTicks, (float)happyGhast.f_20886_, (float)happyGhast.f_20885_);
            float bodyYaw = Mth.m_14189_((float)partialTicks, (float)happyGhast.f_20884_, (float)happyGhast.f_20883_);
            boolean isLocalPlayerDriver = false;
            if (happyGhast.m_20160_() && Minecraft.m_91087_().f_91074_ != null && happyGhast.m_20197_().indexOf(Minecraft.m_91087_().f_91074_) == 0) {
                isLocalPlayerDriver = true;
            }
            if (happyGhast.m_20160_() && !isLocalPlayerDriver) {
                happyGhast.f_20883_ = interpolatedYaw;
                happyGhast.f_20885_ = interpolatedYaw;
            }
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation m_5478_(Ghast entity) {
        return TEXTURE;
    }
}

