/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import dev.nweaver.happyghastmod.util.FolderTextureLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class TextureUtils {
    public static List<File> getAvailableTextures() {
        return FolderTextureLoader.getAvailableTextures();
    }

    public static File getTexturesFolder() {
        return FolderTextureLoader.getTexturesFolder();
    }

    public static boolean validateTextureAspectRatio(byte[] textureData, String textureType) {
        try {
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(textureData));
            int width = nativeImage.m_84982_();
            int height = nativeImage.m_85084_();
            double aspectRatio = (double)width / (double)height;
            boolean isValid = switch (textureType) {
                case "saddle" -> {
                    if (Math.abs(aspectRatio - 2.0) < 0.1) {
                        yield true;
                    }
                    yield false;
                }
                case "glasses" -> {
                    if (Math.abs(aspectRatio - 2.0) < 0.1) {
                        yield true;
                    }
                    yield false;
                }
                case "accessory" -> {
                    if (Math.abs(aspectRatio - 2.0) < 0.1) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
            nativeImage.close();
            return isValid;
        }
        catch (Exception e) {
            return false;
        }
    }
}

