/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TexturePreviewButton
extends Button {
    private final File textureFile;
    private ResourceLocation previewTexture;
    private int textureWidth;
    private int textureHeight;
    private String textureType;
    private String selectedTextureType;

    public TexturePreviewButton(File textureFile, int x, int y, int width, int height, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.m_237113_((String)textureFile.getName()), onPress);
        this.textureFile = textureFile;
        String fileName = textureFile.getName().toLowerCase();
        this.textureType = fileName.contains("accessory") || fileName.contains("_acc") || fileName.contains(" acc") || fileName.endsWith("acc") || fileName.contains("_accessory") || fileName.contains(" accessory") ? "accessory" : (fileName.contains("glasses") || fileName.contains("glass") || fileName.contains("_glass") || fileName.contains(" glass") ? "glasses" : (fileName.contains("saddle") || fileName.contains("_saddle") || fileName.contains(" saddle") ? "saddle" : "saddle"));
        this.selectedTextureType = this.textureType;
        this.loadPreviewTexture();
    }

    public void setSelectedTextureType(String selectedType) {
        this.selectedTextureType = selectedType;
    }

    private void loadPreviewTexture() {
        try {
            byte[] fileData = Files.readAllBytes(this.textureFile.toPath());
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(fileData));
            this.textureWidth = nativeImage.m_84982_();
            this.textureHeight = nativeImage.m_85084_();
            DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
            this.previewTexture = Minecraft.m_91087_().m_91097_().m_118490_("texture/" + UUID.randomUUID().toString(), dynamicTexture);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getTextureFile() {
        return this.textureFile;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int bgColor = this.f_93622_ ? -8947849 : -11184811;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)bgColor);
        if (this.previewTexture != null) {
            int indicatorX = this.f_93620_ + 10;
            int indicatorY = this.f_93621_ + (this.f_93619_ - 10) / 2;
            int indicatorSize = 10;
            boolean isValidRatio = this.isValidAspectRatio(this.selectedTextureType);
            int indicatorColor = isValidRatio ? this.getColorForTextureType(this.selectedTextureType) : -43691;
            GuiComponent.m_93172_((PoseStack)poseStack, (int)indicatorX, (int)indicatorY, (int)(indicatorX + indicatorSize), (int)(indicatorY + indicatorSize), (int)indicatorColor);
            Object filename = this.textureFile.getName();
            if (((String)filename).length() > 45) {
                filename = ((String)filename).substring(0, 42) + "...";
            }
            String typeLabel = this.selectedTextureType.substring(0, 1).toUpperCase() + this.selectedTextureType.substring(1);
            poseStack.m_85836_();
            poseStack.m_85841_(0.65f, 0.65f, 0.65f);
            float scaleFactor = 0.65f;
            int scaledX = (int)((float)(this.f_93620_ + 30) / scaleFactor);
            int scaledY = (int)((float)(this.f_93621_ + (this.f_93619_ - 8) / 2) / scaleFactor);
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)(typeLabel + ": " + (String)filename)), (float)scaledX, (float)scaledY, this.f_93622_ ? 0xFFFFFF : 0xCCCCCC);
            poseStack.m_85849_();
        } else {
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)"Texture loading error"), (float)(this.f_93620_ + 10), (float)(this.f_93621_ + (this.f_93619_ - 10) / 2), 0xFF5555);
        }
    }

    private boolean isValidAspectRatio(String textureTypeToCheck) {
        double aspectRatio = (double)this.textureWidth / (double)this.textureHeight;
        switch (textureTypeToCheck) {
            case "saddle": {
                return Math.abs(aspectRatio - 2.0) < 0.1;
            }
            case "glasses": {
                return Math.abs(aspectRatio - 2.0) < 0.1;
            }
            case "accessory": {
                return Math.abs(aspectRatio - 2.0) < 0.1;
            }
        }
        return false;
    }

    private int getColorForTextureType(String textureTypeToColor) {
        return switch (textureTypeToColor) {
            case "saddle" -> -11141291;
            case "glasses" -> -11184641;
            case "accessory" -> -171;
            default -> -1;
        };
    }
}

