/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.nweaver.happyghastmod.client.gui.StatusMessageManager;
import dev.nweaver.happyghastmod.client.gui.UILayoutHelper;
import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class HarnessTextureManager {
    private final String previewHarnessId;
    private String saddleTextureName = "Not selected";
    private String glassesTextureName = "Not selected";
    private String accessoryTextureName = "Not selected";
    private byte[] saddleTextureData;
    private byte[] glassesTextureData;
    private byte[] accessoryTextureData;
    private ResourceLocation saddlePreviewTexture;
    private ResourceLocation glassesPreviewTexture;
    private ResourceLocation accessoryPreviewTexture;
    private final StatusMessageManager statusManager;
    private PreviewUpdateCallback previewUpdateCallback;

    public HarnessTextureManager(String previewHarnessId) {
        this.previewHarnessId = previewHarnessId;
        this.statusManager = new StatusMessageManager();
    }

    public void selectTexture(File textureFile, String textureType) {
        try {
            byte[] textureData = this.loadTextureData(textureFile);
            if (textureData == null) {
                this.statusManager.showStatus((Component)Component.m_237113_((String)"Error loading texture!"), 0xFF5555);
                return;
            }
            try {
                NativeImage image = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(textureData));
                int width = image.m_84982_();
                int height = image.m_85084_();
                boolean validRatio = false;
                switch (textureType) {
                    case "saddle": {
                        validRatio = Math.abs((double)width / (double)height - 2.0) < 0.1;
                        break;
                    }
                    case "glasses": {
                        validRatio = Math.abs((double)width / (double)height - 2.0) < 0.1;
                        break;
                    }
                    case "accessory": {
                        validRatio = Math.abs((double)width / (double)height - 2.0) < 0.1;
                    }
                }
                image.close();
                if (!validRatio) {
                    this.statusManager.showStatus((Component)Component.m_237113_((String)("Warning: aspect ratio is not optimal for " + this.getLocalizedTypeName(textureType))), 0xFFFF55);
                }
            }
            catch (Exception image) {
                // empty catch block
            }
            String shortName = this.getShortFileName(textureFile);
            switch (textureType) {
                case "saddle": {
                    this.saddleTextureData = textureData;
                    this.saddlePreviewTexture = this.createPreviewTexture(textureData);
                    this.saddleTextureName = shortName;
                    break;
                }
                case "glasses": {
                    this.glassesTextureData = textureData;
                    this.glassesPreviewTexture = this.createPreviewTexture(textureData);
                    this.glassesTextureName = shortName;
                    break;
                }
                case "accessory": {
                    this.accessoryTextureData = textureData;
                    this.accessoryPreviewTexture = this.createPreviewTexture(textureData);
                    this.accessoryTextureName = shortName;
                }
            }
            String typeName = this.getLocalizedTypeName(textureType);
            this.statusManager.showStatus((Component)Component.m_237113_((String)("Selected texture " + typeName + ": " + shortName)), 0x55FF55);
            this.triggerPreviewUpdate();
        }
        catch (Exception e) {
            this.statusManager.showStatus((Component)Component.m_237113_((String)"Error loading texture!"), 0xFF5555);
        }
    }

    public void setPreviewUpdateCallback(PreviewUpdateCallback callback) {
        this.previewUpdateCallback = callback;
    }

    private void triggerPreviewUpdate() {
        if (this.previewUpdateCallback != null) {
            this.previewUpdateCallback.onTextureSelected();
        }
    }

    private String getLocalizedTypeName(String textureType) {
        return switch (textureType) {
            case "saddle" -> "saddle";
            case "glasses" -> "glasses";
            case "accessory" -> "accessory";
            default -> "unknown type";
        };
    }

    private boolean checkTextureAspectRatio(byte[] textureData, String textureType) {
        try {
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(textureData));
            int width = nativeImage.m_84982_();
            int height = nativeImage.m_85084_();
            boolean isValid = switch (textureType) {
                case "saddle" -> {
                    if (Math.abs((double)width / (double)height - 2.0) < 0.1) {
                        yield true;
                    }
                    yield false;
                }
                case "glasses" -> {
                    if (Math.abs((double)width / (double)height - 2.0) < 0.1) {
                        yield true;
                    }
                    yield false;
                }
                case "accessory" -> {
                    if (Math.abs((double)width / (double)height - 2.0) < 0.1) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
            nativeImage.close();
            return isValid;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getAspectRatioInfoForType(String textureType) {
        return switch (textureType) {
            case "saddle" -> "2:1";
            case "glasses" -> "2:1";
            case "accessory" -> "2:1";
            default -> "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435";
        };
    }

    public boolean validateTextureAspectRatio(byte[] textureData, String textureType) {
        return this.checkTextureAspectRatio(textureData, textureType);
    }

    private byte[] loadTextureData(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResourceLocation createPreviewTexture(byte[] textureData) {
        try {
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(textureData));
            DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
            return Minecraft.m_91087_().m_91097_().m_118490_("preview/" + UUID.randomUUID().toString(), dynamicTexture);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void updatePreviewHarness(String previewName, HappyGhast previewGhast) {
        try {
            if (this.saddleTextureData != null) {
                this.validateTextureData(this.saddleTextureData, "Saddle");
            }
            if (this.glassesTextureData != null) {
                this.validateTextureData(this.glassesTextureData, "Glasses");
            }
            if (this.accessoryTextureData != null) {
                this.validateTextureData(this.accessoryTextureData, "Accessory");
            }
            ClientCustomHarnessManager.registerPreviewHarness(this.previewHarnessId, previewName, "\u0412\u044b", this.saddleTextureData, this.glassesTextureData, this.accessoryTextureData);
            if (previewGhast != null) {
                previewGhast.setSaddled(true);
                previewGhast.setHarnessColor("custom:" + this.previewHarnessId);
                previewGhast.refreshSaddle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getShortFileName(File file) {
        String name = file.getName();
        if (name.length() > 12) {
            return name.substring(0, 10) + "...";
        }
        return name;
    }

    public void renderSelectedTexturesBlock(PoseStack poseStack, UILayoutHelper layout, Font font) {
        int baseX = layout.getLeftX() + 140;
        int baseY = layout.getTopY() + 40;
        font.m_92889_(poseStack, (Component)Component.m_237113_((String)"Selected Textures:"), (float)(baseX + 5), (float)(baseY + 5), 0xFFFFFF);
        int firstRowY = baseY + 20;
        int saddleLabelX = baseX + 10;
        int saddleStatusX = baseX + 50;
        font.m_92889_(poseStack, (Component)Component.m_237113_((String)"Saddle:"), (float)saddleLabelX, (float)firstRowY, 0xFFFFFF);
        this.renderCompactTextureInfo(poseStack, saddleStatusX, firstRowY, this.saddleTextureData, false);
        int glassesLabelX = baseX + 70;
        int glassesStatusX = baseX + 125;
        font.m_92889_(poseStack, (Component)Component.m_237113_((String)"Glasses:"), (float)glassesLabelX, (float)firstRowY, 0xFFFFFF);
        this.renderCompactTextureInfo(poseStack, glassesStatusX, firstRowY, this.glassesTextureData, false);
        int secondRowY = baseY + 35;
        int accLabelX = baseX + 70;
        int accStatusX = baseX + 130;
        font.m_92889_(poseStack, (Component)Component.m_237113_((String)"Accessory:"), (float)accLabelX, (float)secondRowY, 0xFFFFFF);
        this.renderCompactTextureInfo(poseStack, accStatusX, secondRowY, this.accessoryTextureData, false);
    }

    private void renderCompactTextureInfo(PoseStack poseStack, int x, int y, byte[] textureData, boolean required) {
        if (textureData != null) {
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)"\u2713"), (float)x, (float)y, 0x55FF55);
        } else {
            String text = "X";
            int color = 0xAAAAAA;
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)text), (float)x, (float)y, color);
        }
    }

    public byte[] getSaddleTextureData() {
        return this.saddleTextureData;
    }

    public boolean hasSaddleTexture() {
        return this.saddleTextureData != null;
    }

    public boolean hasGlassesTexture() {
        return this.glassesTextureData != null;
    }

    public boolean hasAccessoryTexture() {
        return this.accessoryTextureData != null;
    }

    public byte[] getGlassesTextureData() {
        return this.glassesTextureData;
    }

    public byte[] getAccessoryTextureData() {
        return this.accessoryTextureData;
    }

    private void validateTextureData(byte[] textureData, String textureType) {
        try {
            NativeImage image = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(textureData));
            int width = image.m_84982_();
            int height = image.m_85084_();
            image.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface PreviewUpdateCallback {
        public void onTextureSelected();
    }
}

