/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import dev.nweaver.happyghastmod.container.GhastContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastScreen
extends AbstractContainerScreen<GhastContainer> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GHAST_INVENTORY_LOCATION = new ResourceLocation("minecraft", "textures/gui/container/horse.png");
    private float mouseX;
    private float mouseY;
    private float modelScale = 6.0f;
    private float modelY = 0.0f;
    private float modelZ = 30.0f;
    private static final float MAX_Y_ROTATION = 30.0f;
    private static final float MAX_X_ROTATION = 15.0f;

    public GhastScreen(GhastContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int pMouseX, int pMouseY) {
        this.mouseX = pMouseX;
        this.mouseY = pMouseY;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GHAST_INVENTORY_LOCATION);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (((GhastContainer)this.f_97732_).ghast != null) {
            try {
                this.renderEntityInInventory(poseStack, x + 51, y + 60, (LivingEntity)((GhastContainer)this.f_97732_).ghast);
            }
            catch (Exception e) {
                LOGGER.error("Failed to render 3D model: {}", (Object)e.getMessage());
            }
        } else {
            MutableComponent errorMessage = Component.m_237113_((String)"\u041e\u0448\u0438\u0431\u043a\u0430: \u0433\u0430\u0441\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            int errorX = x + (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)errorMessage)) / 2;
            this.f_96547_.m_92889_(poseStack, (Component)errorMessage, (float)errorX, (float)(y + 45), -65536);
            MutableComponent additionalInfo = Component.m_237113_((String)"\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0437\u0430\u043d\u043e\u0432\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c");
            int infoX = x + (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)additionalInfo)) / 2;
            this.f_96547_.m_92889_(poseStack, (Component)additionalInfo, (float)infoX, (float)(y + 60), -22016);
        }
    }

    private void renderEntityInInventory(PoseStack poseStack, int posX, int posY, LivingEntity entity) {
        try {
            poseStack.m_85836_();
            poseStack.m_85837_((double)posX, (double)posY, (double)this.modelZ);
            poseStack.m_85841_(this.modelScale, this.modelScale, this.modelScale);
            float originalYRot = entity.m_146908_();
            float originalXRot = entity.m_146909_();
            float originalYHeadRot = entity.f_20885_;
            float originalYBodyRot = entity.f_20883_;
            entity.m_146922_(0.0f);
            entity.m_146926_(0.0f);
            entity.f_20885_ = 0.0f;
            entity.f_20883_ = 0.0f;
            float mousePosX = this.mouseX - (float)posX;
            float mousePosY = this.mouseY - (float)posY;
            float angleY = Mth.m_14036_((float)((float)Math.atan(mousePosX / 40.0f) * 20.0f), (float)-30.0f, (float)30.0f);
            float angleX = Mth.m_14036_((float)((float)Math.atan(mousePosY / 40.0f) * 20.0f), (float)-15.0f, (float)15.0f);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(angleY));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(angleX));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            poseStack.m_85837_(0.0, (double)this.modelY, 0.0);
            Lighting.m_166384_();
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            dispatcher.m_114412_(new Quaternion(0.0f, 0.0f, 0.0f, 1.0f));
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            dispatcher.m_114468_(false);
            RenderSystem.m_69890_(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
            bufferSource.m_109911_();
            dispatcher.m_114468_(true);
            Lighting.m_84931_();
            entity.m_146922_(originalYRot);
            entity.m_146926_(originalXRot);
            entity.f_20885_ = originalYHeadRot;
            entity.f_20883_ = originalYBodyRot;
            poseStack.m_85849_();
        }
        catch (Exception e) {
            LOGGER.error("Error rendering entity: {}", (Object)e.getMessage());
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        MutableComponent title = Component.m_237113_((String)"Happy Ghast Inventory");
        this.f_96547_.m_92889_(poseStack, (Component)title, 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(poseStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }
}

