/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class EntityPreviewRenderer {
    private final HappyGhast previewEntity;
    private float rotationX = 0.0f;
    private float rotationY = 0.0f;
    private float modelScale = 5.0f;
    private float modelY = 0.0f;
    private float modelZ = 30.0f;
    private boolean isRotating = false;
    private int lastMouseX;
    private int lastMouseY;

    public EntityPreviewRenderer(HappyGhast previewEntity) {
        this.previewEntity = previewEntity;
    }

    public void renderPreview(PoseStack poseStack, int previewX, int previewY, int previewWidth, int previewHeight, Font font) {
        if (this.previewEntity == null) {
            return;
        }
        GuiComponent.m_93172_((PoseStack)poseStack, (int)previewX, (int)previewY, (int)(previewX + previewWidth), (int)(previewY + previewHeight), (int)-14671840);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)previewX, (int)previewY, (int)(previewX + previewWidth), (int)(previewY + 2), (int)-11184811);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)previewX, (int)(previewY + previewHeight - 2), (int)(previewX + previewWidth), (int)(previewY + previewHeight), (int)-11184811);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)previewX, (int)previewY, (int)(previewX + 2), (int)(previewY + previewHeight), (int)-11184811);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(previewX + previewWidth - 2), (int)previewY, (int)(previewX + previewWidth), (int)(previewY + previewHeight), (int)-11184811);
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)font, (Component)Component.m_237113_((String)"Preview"), (int)(previewX + previewWidth / 2), (int)(previewY - 10), (int)0xFFFFFF);
        this.renderEntityInArea(poseStack, previewX + previewWidth / 2, previewY + previewHeight / 2 + 15);
    }

    private void renderEntityInArea(PoseStack poseStack, int posX, int posY) {
        try {
            poseStack.m_85836_();
            poseStack.m_85837_((double)posX, (double)posY, (double)this.modelZ);
            poseStack.m_85841_(this.modelScale, this.modelScale, this.modelScale);
            float originalYRot = this.previewEntity.m_146908_();
            float originalXRot = this.previewEntity.m_146909_();
            float originalYHeadRot = this.previewEntity.f_20885_;
            float originalYBodyRot = this.previewEntity.f_20883_;
            this.previewEntity.m_146922_(0.0f);
            this.previewEntity.m_146926_(0.0f);
            this.previewEntity.f_20885_ = 0.0f;
            this.previewEntity.f_20883_ = 0.0f;
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(this.rotationY));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(this.rotationX));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            poseStack.m_85837_(0.0, (double)this.modelY, 0.0);
            Lighting.m_166384_();
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            dispatcher.m_114412_(new Quaternion(0.0f, 0.0f, 0.0f, 1.0f));
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            dispatcher.m_114468_(false);
            RenderSystem.m_69890_(() -> dispatcher.m_114384_((Entity)this.previewEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
            bufferSource.m_109911_();
            dispatcher.m_114468_(true);
            Lighting.m_84931_();
            this.previewEntity.m_146922_(originalYRot);
            this.previewEntity.m_146926_(originalXRot);
            this.previewEntity.f_20885_ = originalYHeadRot;
            this.previewEntity.f_20883_ = originalYBodyRot;
            poseStack.m_85849_();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInPreviewArea(double mouseX, double mouseY, int previewX, int previewY, int previewWidth, int previewHeight) {
        return mouseX >= (double)previewX && mouseX <= (double)(previewX + previewWidth) && mouseY >= (double)previewY && mouseY <= (double)(previewY + previewHeight);
    }

    public void startRotating(int mouseX, int mouseY) {
        this.isRotating = true;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void stopRotating() {
        this.isRotating = false;
    }

    public void updateRotation(int mouseX, int mouseY) {
        this.rotationY += (float)(mouseX - this.lastMouseX) * 2.0f;
        this.rotationX += (float)(mouseY - this.lastMouseY) * 2.0f;
        this.rotationX = Mth.m_14036_((float)this.rotationX, (float)-30.0f, (float)30.0f);
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public boolean isRotating() {
        return this.isRotating;
    }

    public HappyGhast getPreviewEntity() {
        return this.previewEntity;
    }
}

