/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.nweaver.happyghastmod.client.gui.EntityPreviewRenderer;
import dev.nweaver.happyghastmod.client.gui.HarnessTextureManager;
import dev.nweaver.happyghastmod.client.gui.StatusMessageManager;
import dev.nweaver.happyghastmod.client.gui.TexturePreviewButton;
import dev.nweaver.happyghastmod.client.gui.TextureUtils;
import dev.nweaver.happyghastmod.client.gui.UILayoutHelper;
import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.init.EntityInit;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import dev.nweaver.happyghastmod.network.RegisterCustomHarnessPacket;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomHarnessCreator
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PREVIEW_HARNESS_ID = "preview-harness-id";
    private final UILayoutHelper layout;
    private final HarnessTextureManager textureManager;
    private final EntityPreviewRenderer entityRenderer;
    private final StatusMessageManager statusManager;
    private EditBox harnessNameField;
    private List<TexturePreviewButton> textureButtons = new ArrayList<TexturePreviewButton>();
    private String currentTextureType = "saddle";
    private int scrollOffset = 0;
    private int maxTexturesVisible = 3;
    private boolean harnessNameFieldEmpty = true;

    public CustomHarnessCreator() {
        super((Component)Component.m_237113_((String)"Create Custom Harness"));
        this.layout = new UILayoutHelper();
        this.textureManager = new HarnessTextureManager(PREVIEW_HARNESS_ID);
        this.statusManager = new StatusMessageManager();
        HappyGhast previewGhast = null;
        try {
            if (Minecraft.m_91087_().f_91073_ != null && (previewGhast = (HappyGhast)((EntityType)EntityInit.HAPPY_GHAST.get()).m_20615_((Level)Minecraft.m_91087_().f_91073_)) != null) {
                previewGhast.setSaddled(true);
                previewGhast.setHarnessColor("blue");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entityRenderer = new EntityPreviewRenderer(previewGhast);
        try {
            ClientCustomHarnessManager.unregisterPreviewHarness(PREVIEW_HARNESS_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void m_7856_() {
        this.layout.calculateLayout(this.f_96543_, this.f_96544_);
        this.harnessNameField = new EditBox(this.f_96547_, this.layout.getNameFieldX(), this.layout.getNameFieldY(), this.layout.getNameFieldWidth(), 20, (Component)Component.m_237113_((String)""));
        this.harnessNameField.m_94199_(32);
        this.harnessNameField.m_94144_("");
        this.m_142416_((GuiEventListener)this.harnessNameField);
        this.m_142416_((GuiEventListener)new Button(this.layout.getFolderButtonX(), this.layout.getFolderButtonY(), 90, 20, (Component)Component.m_237113_((String)"Open Folder"), button -> this.openTexturesFolder()));
        this.addTextureTypeButtons();
        this.addNavigationButtons();
        this.addActionButtons();
        this.refreshTextureList();
        this.textureManager.setPreviewUpdateCallback(new HarnessTextureManager.PreviewUpdateCallback(){

            @Override
            public void onTextureSelected() {
                Minecraft.m_91087_().execute(() -> {
                    String previewName = CustomHarnessCreator.this.harnessNameField.m_94155_().isEmpty() ? "\u041f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440" : CustomHarnessCreator.this.harnessNameField.m_94155_();
                    CustomHarnessCreator.this.updatePreviewHarness();
                });
            }
        });
    }

    private void addTextureTypeButtons() {
        int tabWidth = 60;
        int tabHeight = 20;
        this.m_142416_((GuiEventListener)new Button(this.layout.getTypeButtonX(), this.layout.getTypeButtonY(), tabWidth, tabHeight, (Component)Component.m_237113_((String)"Saddle"), button -> this.selectTextureType("saddle")));
        this.m_142416_((GuiEventListener)new Button(this.layout.getTypeButtonX() + tabWidth + 5, this.layout.getTypeButtonY(), tabWidth, tabHeight, (Component)Component.m_237113_((String)"Glasses"), button -> this.selectTextureType("glasses")));
        this.m_142416_((GuiEventListener)new Button(this.layout.getTypeButtonX(), this.layout.getTypeButtonY() + tabHeight + 5, tabWidth, tabHeight, (Component)Component.m_237113_((String)"Accessory"), button -> this.selectTextureType("accessory")));
    }

    private void addNavigationButtons() {
        this.m_142416_((GuiEventListener)new Button(this.layout.getLeftNavButtonX(), this.layout.getNavButtonY(), 30, 20, (Component)Component.m_237113_((String)"\u25c0"), button -> this.scrollUp()));
        this.m_142416_((GuiEventListener)new Button(this.layout.getRightNavButtonX(), this.layout.getNavButtonY(), 30, 20, (Component)Component.m_237113_((String)"\u25b6"), button -> this.scrollDown()));
    }

    private void addActionButtons() {
        this.m_142416_((GuiEventListener)new Button(this.layout.getCreateButtonX(), this.layout.getCreateButtonY(), 130, 20, (Component)Component.m_237113_((String)"CREATE HARNESS"), button -> this.createHarness()));
        this.m_142416_((GuiEventListener)new Button(this.layout.getCancelButtonX(), this.layout.getCancelButtonY(), 70, 20, (Component)Component.m_237113_((String)"Cancel"), button -> this.m_7379_()));
    }

    public void m_7379_() {
        try {
            ClientCustomHarnessManager.unregisterPreviewHarness(PREVIEW_HARNESS_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.m_7379_();
    }

    private void refreshTextureList() {
        for (TexturePreviewButton button : this.textureButtons) {
            this.m_169411_((GuiEventListener)button);
        }
        this.textureButtons.clear();
        List<File> textures = TextureUtils.getAvailableTextures();
        if (textures.isEmpty()) {
            return;
        }
        this.maxTexturesVisible = 1;
        int maxScrollOffset = Math.max(0, textures.size() - this.maxTexturesVisible);
        this.scrollOffset = Math.min(this.scrollOffset, maxScrollOffset);
        if (this.scrollOffset < textures.size()) {
            File file = textures.get(this.scrollOffset);
            TexturePreviewButton button = new TexturePreviewButton(file, this.layout.getTextureButtonX(), this.layout.getTextureButtonY(), this.layout.getTextureButtonWidth(), this.layout.getTextureButtonHeight(), b -> this.selectTexture(((TexturePreviewButton)b).getTextureFile()));
            button.setSelectedTextureType(this.currentTextureType);
            this.textureButtons.add(button);
            this.m_142416_((GuiEventListener)button);
        }
    }

    private void selectTextureType(String textureType) {
        this.currentTextureType = textureType;
        for (TexturePreviewButton button : this.textureButtons) {
            button.setSelectedTextureType(textureType);
        }
        this.statusManager.showStatus((Component)Component.m_237113_((String)("Selected texture type: " + textureType)), 0x55FFFF);
    }

    private void selectTexture(File textureFile) {
        this.textureManager.selectTexture(textureFile, this.currentTextureType);
        this.updatePreviewHarness();
    }

    private void updatePreviewHarness() {
        String previewName = this.harnessNameField.m_94155_().isEmpty() ? "Preview" : this.harnessNameField.m_94155_();
        this.textureManager.updatePreviewHarness(previewName, this.entityRenderer.getPreviewEntity());
    }

    private void scrollUp() {
        if (this.scrollOffset > 0) {
            --this.scrollOffset;
            this.refreshTextureList();
        }
    }

    private void scrollDown() {
        List<File> textures = TextureUtils.getAvailableTextures();
        int maxScrollOffset = Math.max(0, textures.size() - this.maxTexturesVisible);
        if (this.scrollOffset < maxScrollOffset) {
            ++this.scrollOffset;
            this.refreshTextureList();
        }
    }

    private void openTexturesFolder() {
        File folder = TextureUtils.getTexturesFolder();
        try {
            Desktop.getDesktop().open(folder);
        }
        catch (Exception e) {
            this.statusManager.showStatus((Component)Component.m_237113_((String)("Folder: " + folder.getAbsolutePath())), 0xFFFFAA);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.layout.renderMainPanel(poseStack, this.f_96547_, this.f_96539_);
        CustomHarnessCreator.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237113_((String)"Name:"), (int)this.layout.getNameLabelX(), (int)this.layout.getNameLabelY(), (int)0xFFFFFF);
        if (this.harnessNameField.m_94155_().isEmpty()) {
            CustomHarnessCreator.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237113_((String)"Enter harness name"), (int)(this.harnessNameField.f_93620_ + 4), (int)(this.harnessNameField.f_93621_ + 6), (int)0x808080);
        }
        this.entityRenderer.renderPreview(poseStack, this.layout.getPreviewX(), this.layout.getPreviewY(), this.layout.getPreviewWidth(), this.layout.getPreviewHeight(), this.f_96547_);
        this.renderTextureSelectionArea(poseStack);
        this.textureManager.renderSelectedTexturesBlock(poseStack, this.layout, this.f_96547_);
        this.statusManager.renderStatusMessage(poseStack, this.f_96547_, this.layout.getStatusX(), this.layout.getStatusY());
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void renderTextureSelectionArea(PoseStack poseStack) {
        int textureAreaY = this.layout.getTextureAreaY();
        String currentTypeLabel = switch (this.currentTextureType) {
            case "saddle" -> "Selecting Saddle Texture";
            case "glasses" -> "Selecting Glasses Texture";
            case "accessory" -> "Selecting Accessory Texture";
            default -> "Select Texture";
        };
        CustomHarnessCreator.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237113_((String)currentTypeLabel), (int)(this.layout.getLeftX() + this.layout.getGuiWidth() / 2), (int)(textureAreaY + 5), (int)0xFFFF55);
        List<File> textures = TextureUtils.getAvailableTextures();
        if (!textures.isEmpty()) {
            String counter = this.scrollOffset + 1 + "/" + textures.size();
            CustomHarnessCreator.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237113_((String)counter), (int)(this.layout.getLeftX() + this.layout.getGuiWidth() / 2 - 15), (int)(textureAreaY + 20), (int)0xCCCCCC);
        }
        CustomHarnessCreator.m_93172_((PoseStack)poseStack, (int)(this.layout.getLeftX() + 15), (int)(textureAreaY + this.layout.getTextureAreaHeight()), (int)(this.layout.getLeftX() + this.layout.getGuiWidth() - 15), (int)(textureAreaY + this.layout.getTextureAreaHeight() + 2), (int)-11184811);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.entityRenderer.isInPreviewArea(mouseX, mouseY, this.layout.getPreviewX(), this.layout.getPreviewY(), this.layout.getPreviewWidth(), this.layout.getPreviewHeight())) {
            this.entityRenderer.startRotating((int)mouseX, (int)mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.entityRenderer.stopRotating();
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.entityRenderer.isRotating()) {
            this.entityRenderer.updateRotation((int)mouseX, (int)mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void createHarness() {
        String harnessName = this.harnessNameField.m_94155_().trim();
        if (harnessName.isEmpty()) {
            this.statusManager.showStatus((Component)Component.m_237113_((String)"Please enter a harness name"), 0xFF5555);
            return;
        }
        if (!this.validateAllTexturesAspectRatio()) {
            return;
        }
        String harnessId = UUID.randomUUID().toString();
        try {
            NetworkHandler.sendToServer(new RegisterCustomHarnessPacket(harnessId, harnessName, this.textureManager.getSaddleTextureData(), this.textureManager.getGlassesTextureData(), this.textureManager.getAccessoryTextureData()));
            this.statusManager.showStatus((Component)Component.m_237113_((String)"Harness created successfully!"), 0x55FF55);
            new Thread(() -> {
                try {
                    Thread.sleep(2000L);
                    Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_(null));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }).start();
        }
        catch (Exception e) {
            this.statusManager.showStatus((Component)Component.m_237113_((String)"Error creating harness"), 0xFF5555);
        }
    }

    private boolean validateAllTexturesAspectRatio() {
        if (this.textureManager.getSaddleTextureData() != null && !TextureUtils.validateTextureAspectRatio(this.textureManager.getSaddleTextureData(), "saddle")) {
            this.statusManager.showStatus((Component)Component.m_237113_((String)"Saddle texture must have 2:1 aspect ratio"), 0xFF5555);
            return false;
        }
        if (this.textureManager.getGlassesTextureData() != null && !TextureUtils.validateTextureAspectRatio(this.textureManager.getGlassesTextureData(), "glasses")) {
            this.statusManager.showStatus((Component)Component.m_237113_((String)"Glasses texture must have 2:1 aspect ratio"), 0xFF5555);
            return false;
        }
        if (this.textureManager.getAccessoryTextureData() != null && !TextureUtils.validateTextureAspectRatio(this.textureManager.getAccessoryTextureData(), "accessory")) {
            this.statusManager.showStatus((Component)Component.m_237113_((String)"Accessory texture must have 2:1 aspect ratio"), 0xFF5555);
            return false;
        }
        return true;
    }
}

