/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.block.entity;

import dev.nweaver.happyghastmod.block.GhastlingIncubatorBlock;
import dev.nweaver.happyghastmod.block.IncubationStage;
import dev.nweaver.happyghastmod.entity.Ghastling;
import dev.nweaver.happyghastmod.init.BlockEntityInit;
import dev.nweaver.happyghastmod.init.EntityInit;
import dev.nweaver.happyghastmod.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class GhastlingIncubatorBlockEntity
extends BlockEntity {
    public static final int TARGET_INCUBATION_TICKS = 24000;
    private static final int ACCELERATION_TICKS_PER_USE = 2400;
    private int incubationTicks = 0;
    private IncubationStage lastStage = IncubationStage.DRIED;
    private boolean wasWaterlogged = false;
    private int ambientSoundTimer = 0;
    private static final int AMBIENT_SOUND_INTERVAL = 200;

    public GhastlingIncubatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.GHASTLING_INCUBATOR.get(), pos, state);
        this.wasWaterlogged = (Boolean)state.m_61143_((Property)GhastlingIncubatorBlock.WATERLOGGED);
    }

    public int getIncubationTicks() {
        return this.incubationTicks;
    }

    public boolean accelerateIncubation() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        if (this.incubationTicks >= 24000) {
            return false;
        }
        this.incubationTicks += 2400;
        this.incubationTicks = Mth.m_14045_((int)this.incubationTicks, (int)0, (int)24000);
        this.updateIncubationStage();
        this.m_6596_();
        if (this.incubationTicks >= 24000) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundInit.GHASTLING_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            GhastlingIncubatorBlockEntity.spawnGhastling(this.f_58857_, this.f_58858_);
            this.f_58857_.m_46961_(this.f_58858_, false);
            return true;
        }
        return false;
    }

    private void updateIncubationStage() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState currentState = this.f_58857_.m_8055_(this.f_58858_);
            IncubationStage currentStage = GhastlingIncubatorBlock.getStageFromProgress(this.incubationTicks, 24000);
            if (currentStage != this.lastStage) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)currentState.m_61124_(GhastlingIncubatorBlock.INCUBATION_STAGE, (Comparable)((Object)currentStage)), 3);
                this.lastStage = currentStage;
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GhastlingIncubatorBlockEntity blockEntity) {
        boolean isWaterlogged = (Boolean)state.m_61143_((Property)GhastlingIncubatorBlock.WATERLOGGED);
        if (isWaterlogged != blockEntity.wasWaterlogged) {
            level.m_5594_(null, pos, (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            blockEntity.wasWaterlogged = isWaterlogged;
        }
        ++blockEntity.ambientSoundTimer;
        if (blockEntity.ambientSoundTimer >= 200) {
            blockEntity.ambientSoundTimer = 0;
            GhastlingIncubatorBlock.playAmbientSound(level, pos, isWaterlogged);
        }
        if (blockEntity.incubationTicks >= 24000) {
            return;
        }
        if (isWaterlogged) {
            ++blockEntity.incubationTicks;
            blockEntity.updateIncubationStage();
            if (blockEntity.incubationTicks >= 24000) {
                level.m_5594_(null, pos, (SoundEvent)SoundInit.GHASTLING_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                GhastlingIncubatorBlockEntity.spawnGhastling(level, pos);
                level.m_46961_(pos, false);
            } else {
                blockEntity.m_6596_();
            }
        } else if (blockEntity.incubationTicks > 0) {
            blockEntity.incubationTicks = 0;
            BlockState currentState = level.m_8055_(pos);
            if (currentState.m_61143_(GhastlingIncubatorBlock.INCUBATION_STAGE) != IncubationStage.DRIED) {
                level.m_7731_(pos, (BlockState)currentState.m_61124_(GhastlingIncubatorBlock.INCUBATION_STAGE, (Comparable)((Object)IncubationStage.DRIED)), 3);
                blockEntity.lastStage = IncubationStage.DRIED;
                level.m_5594_(null, pos, (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            blockEntity.m_6596_();
            System.out.println("Incubator at " + String.valueOf(pos) + " is no longer waterlogged, progress reset.");
        }
    }

    private static void spawnGhastling(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType ghastlingType = (EntityType)EntityInit.GHASTLING.get();
            Vec3 spawnPos = Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, 0.6, 0.0);
            Ghastling ghastling = (Ghastling)ghastlingType.m_20615_((Level)serverLevel);
            if (ghastling != null) {
                ghastling.m_6034_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_());
                if (serverLevel.m_7967_((Entity)ghastling)) {
                    System.out.println("Ghastling spawned from incubator at " + String.valueOf(pos));
                    level.m_5594_(null, pos, (SoundEvent)SoundInit.GHASTLING_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    System.err.println("Failed to add Ghastling to world at " + String.valueOf(pos));
                }
            } else {
                System.err.println("Failed to create Ghastling instance for incubator at " + String.valueOf(pos));
            }
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("IncubationTicks", this.incubationTicks);
        nbt.m_128359_("LastStage", this.lastStage.m_7912_());
        nbt.m_128379_("WasWaterlogged", this.wasWaterlogged);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.incubationTicks = nbt.m_128451_("IncubationTicks");
        this.wasWaterlogged = nbt.m_128471_("WasWaterlogged");
        if (nbt.m_128441_("LastStage")) {
            String stageName = nbt.m_128461_("LastStage");
            for (IncubationStage stage : IncubationStage.values()) {
                if (!stage.m_7912_().equals(stageName)) continue;
                this.lastStage = stage;
                break;
            }
        }
    }
}

