/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.block;

import dev.nweaver.happyghastmod.block.IncubationStage;
import dev.nweaver.happyghastmod.block.entity.GhastlingIncubatorBlockEntity;
import dev.nweaver.happyghastmod.init.BlockEntityInit;
import dev.nweaver.happyghastmod.init.ItemInit;
import dev.nweaver.happyghastmod.init.SoundInit;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GhastlingIncubatorBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<IncubationStage> INCUBATION_STAGE = EnumProperty.m_61587_((String)"incubation_stage", IncubationStage.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_NORTH = GhastlingIncubatorBlock.createShapeForDirection(Direction.NORTH);
    private static final VoxelShape SHAPE_EAST = GhastlingIncubatorBlock.createShapeForDirection(Direction.EAST);
    private static final VoxelShape SHAPE_SOUTH = GhastlingIncubatorBlock.createShapeForDirection(Direction.SOUTH);
    private static final VoxelShape SHAPE_WEST = GhastlingIncubatorBlock.createShapeForDirection(Direction.WEST);
    private static final VoxelShape SHAPE = GhastlingIncubatorBlock.createShape();

    private static VoxelShape createShapeForDirection(Direction direction) {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.625, (double)0.8125));
        switch (direction) {
            case NORTH: {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.125, (double)0.4375));
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.625, (double)0.9375, (double)0.125, (double)0.75));
                break;
            }
            case EAST: {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5625, (double)0.0, (double)0.0625, (double)0.6875, (double)0.125, (double)0.9375));
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.0625, (double)0.375, (double)0.125, (double)0.9375));
                break;
            }
            case SOUTH: {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.5625, (double)0.9375, (double)0.125, (double)0.6875));
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.25, (double)0.9375, (double)0.125, (double)0.375));
                break;
            }
            case WEST: {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.0625, (double)0.4375, (double)0.125, (double)0.9375));
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.0, (double)0.0625, (double)0.75, (double)0.125, (double)0.9375));
                break;
            }
            default: {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.125, (double)0.4375));
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.625, (double)0.9375, (double)0.125, (double)0.75));
            }
        }
        return shape;
    }

    private static VoxelShape createShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.625, (double)0.8125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.125, (double)0.4375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.625, (double)0.9375, (double)0.125, (double)0.75));
        return shape;
    }

    public GhastlingIncubatorBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76419_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56736_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(INCUBATION_STAGE, (Comparable)((Object)IncubationStage.DRIED))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, INCUBATION_STAGE, FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    public static BlockState setIncubationStage(BlockState state, IncubationStage stage) {
        return (BlockState)state.m_61124_(INCUBATION_STAGE, (Comparable)((Object)stage));
    }

    public static IncubationStage getStageFromProgress(int progress, int targetProgress) {
        float percentage = (float)progress / (float)targetProgress * 100.0f;
        if (percentage >= 66.7f) {
            return IncubationStage.HAPPY;
        }
        if (percentage >= 33.3f) {
            return IncubationStage.NEUTRAL;
        }
        return IncubationStage.DRIED;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        ItemStack itemInHand = player.m_21120_(hand);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof GhastlingIncubatorBlockEntity) {
            GhastlingIncubatorBlockEntity incubatorBe = (GhastlingIncubatorBlockEntity)blockEntity;
            if (itemInHand.m_150930_(Items.f_42586_)) {
                boolean isWaterlogged = (Boolean)state.m_61143_((Property)WATERLOGGED);
                int currentTicks = incubatorBe.getIncubationTicks();
                int targetTicks = 24000;
                if (isWaterlogged && currentTicks < targetTicks) {
                    boolean didComplete = incubatorBe.accelerateIncubation();
                    if (!player.m_150110_().f_35937_) {
                        itemInHand.m_41774_(1);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_12404_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5, 10, 0.3, 0.3, 0.3, 0.05);
                    }
                    this.updateIncubationStage(level, pos, incubatorBe);
                    if (didComplete) {
                        player.m_213846_((Component)Component.m_237113_((String)"Incubation complete!").m_130940_(ChatFormatting.LIGHT_PURPLE));
                    }
                    return InteractionResult.CONSUME;
                }
                if (!isWaterlogged) {
                    player.m_213846_((Component)Component.m_237113_((String)"Incubator must be waterlogged to accelerate.").m_130940_(ChatFormatting.YELLOW));
                    return InteractionResult.FAIL;
                }
                player.m_213846_((Component)Component.m_237113_((String)"Incubation is already complete.").m_130940_(ChatFormatting.GRAY));
                return InteractionResult.PASS;
            }
            if (itemInHand.m_150930_(Items.f_42398_)) {
                int currentTicks = incubatorBe.getIncubationTicks();
                int targetTicks = 24000;
                if (targetTicks > 0) {
                    int progressPercent = (int)((double)currentTicks / (double)targetTicks * 100.0);
                    long remainingSeconds = (long)(targetTicks - currentTicks) / 20L;
                    long remainingMinutes = remainingSeconds / 60L;
                    boolean isWaterlogged = (Boolean)state.m_61143_((Property)WATERLOGGED);
                    MutableComponent message = isWaterlogged ? Component.m_237113_((String)"Incubation progress: ").m_7220_((Component)Component.m_237113_((String)(progressPercent + "%")).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" (approx. ")).m_7220_((Component)Component.m_237113_((String)String.format("%d min %d sec", remainingMinutes, remainingSeconds %= 60L)).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)" remaining while waterlogged)")) : Component.m_237113_((String)"Incubator must be waterlogged. Progress: ").m_7220_((Component)Component.m_237113_((String)(progressPercent + "%")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"."));
                    player.m_213846_((Component)message);
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Incubation target time not set correctly.").m_130940_(ChatFormatting.RED));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void updateIncubationStage(Level level, BlockPos pos, GhastlingIncubatorBlockEntity entity) {
        IncubationStage newStage;
        BlockState currentState;
        IncubationStage oldStage;
        if (!level.f_46443_ && (oldStage = (IncubationStage)((Object)(currentState = level.m_8055_(pos)).m_61143_(INCUBATION_STAGE))) != (newStage = GhastlingIncubatorBlock.getStageFromProgress(entity.getIncubationTicks(), 24000))) {
            level.m_5594_(null, pos, (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)currentState.m_61124_(INCUBATION_STAGE, (Comparable)((Object)newStage)), 3);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean isWater = fluidstate.m_76152_() == Fluids.f_76193_;
        Direction direction = context.m_8125_().m_122424_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (!level.m_5776_() && isWater) {
            level.m_5594_(null, pos, (SoundEvent)SoundInit.DRIED_GHAST_PLACE_IN_WATER.get(), SoundSource.BLOCKS, 0.8f, 0.96f);
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater))).m_61124_(INCUBATION_STAGE, (Comparable)((Object)IncubationStage.DRIED))).m_61124_((Property)FACING, (Comparable)direction);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        boolean isNowWaterlogged;
        BlockState oldState;
        boolean wasWaterlogged;
        Level level;
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        Level level2 = level = levelAccessor instanceof Level ? (Level)levelAccessor : null;
        if (level != null && !level.m_5776_() && (wasWaterlogged = ((Boolean)(oldState = level.m_8055_(currentPos)).m_61143_((Property)WATERLOGGED)).booleanValue()) != (isNowWaterlogged = ((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue())) {
            level.m_5594_(null, currentPos, (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return super.m_7417_(stateIn, facing, facingState, levelAccessor, currentPos, facingPos);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GhastlingIncubatorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.m_5776_()) {
            return null;
        }
        return GhastlingIncubatorBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityInit.GHASTLING_INCUBATOR.get()), GhastlingIncubatorBlockEntity::serverTick);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        if (!level.f_46443_) {
            level.m_5594_(null, pos, (SoundEvent)SoundInit.DRIED_GHAST_BREAK.get(), SoundSource.BLOCKS, 0.8f, 0.96f);
        }
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        if (!level.f_46443_ && blockEntity instanceof GhastlingIncubatorBlockEntity) {
            GhastlingIncubatorBlockEntity incubator = (GhastlingIncubatorBlockEntity)blockEntity;
            int progress = incubator.getIncubationTicks();
            int maxProgress = 24000;
            float progressPercentage = (float)progress / (float)maxProgress;
            ItemStack dropStack = new ItemStack((ItemLike)ItemInit.GHASTLING_INCUBATOR_ITEM.get());
            if (progress > 0) {
                dropStack.m_41784_().m_128405_("IncubationProgress", progress);
                if (progressPercentage >= 0.05f) {
                    String tooltip = String.format("Incubation: %.1f%%", Float.valueOf(progressPercentage * 100.0f));
                    dropStack.m_41784_().m_128359_("IncubationTooltip", tooltip);
                }
            }
            GhastlingIncubatorBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)dropStack);
        }
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.f_46443_) {
            level.m_5594_(null, pos, (SoundEvent)SoundInit.DRIED_GHAST_HIT.get(), SoundSource.BLOCKS, 0.2f, 0.6f);
        }
        super.m_6256_(state, level, pos, player);
    }

    public static void playAmbientSound(Level level, BlockPos pos, boolean isWaterlogged) {
        if (!level.f_46443_ && level.f_46441_.m_188503_(300) < 5) {
            if (isWaterlogged) {
                level.m_5594_(null, pos, (SoundEvent)SoundInit.DRIED_GHAST_AMBIENT_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                level.m_5594_(null, pos, (SoundEvent)SoundInit.DRIED_GHAST_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

