/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod;

import com.mojang.brigadier.CommandDispatcher;
import dev.nweaver.happyghastmod.client.gui.GhastScreen;
import dev.nweaver.happyghastmod.command.GhastRideCommand;
import dev.nweaver.happyghastmod.command.GhastSpeedCommand;
import dev.nweaver.happyghastmod.command.HarnessCreatorCommand;
import dev.nweaver.happyghastmod.command.ListHappyGhastsCommand;
import dev.nweaver.happyghastmod.core.registration.ModBiomeModifiers;
import dev.nweaver.happyghastmod.core.registration.ModConfiguredFeatures;
import dev.nweaver.happyghastmod.core.registration.ModFeatures;
import dev.nweaver.happyghastmod.core.registration.ModPlacedFeatures;
import dev.nweaver.happyghastmod.init.BlockEntityInit;
import dev.nweaver.happyghastmod.init.BlockInit;
import dev.nweaver.happyghastmod.init.ContainerInit;
import dev.nweaver.happyghastmod.init.EntityInit;
import dev.nweaver.happyghastmod.init.ItemInit;
import dev.nweaver.happyghastmod.init.SoundInit;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="happyghastmod")
public class HappyGhastMod {
    public static final String MODID = "happyghastmod";
    public static final Logger LOGGER = LogManager.getLogger((String)"happyghastmod");

    public HappyGhastMod() {
        LOGGER.info("Initializing Happy Ghast Mod");
        LOGGER.info("Initializing Mixins for passenger synchronization");
        try {
            LOGGER.info("Mixins initialized successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize mixins", (Throwable)e);
        }
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        EntityInit.ENTITIES.register(bus);
        ItemInit.ITEMS.register(bus);
        BlockInit.BLOCKS.register(bus);
        BlockEntityInit.BLOCK_ENTITIES.register(bus);
        ContainerInit.CONTAINERS.register(bus);
        ModFeatures.register(bus);
        ModConfiguredFeatures.register(bus);
        ModPlacedFeatures.register(bus);
        ModBiomeModifiers.register(bus);
        SoundInit.register(bus);
        bus.addListener(this::commonSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetup));
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("Mod initialization complete");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Running common setup");
        event.enqueueWork(() -> NetworkHandler.init());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Running client setup");
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)ContainerInit.GHAST_CONTAINER.get()), GhastScreen::new));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandBuildContext buildContext = event.getBuildContext();
        ListHappyGhastsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        GhastRideCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        HarnessCreatorCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        GhastSpeedCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }
}

