/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.tag.TagHandler;
import com.bobmowzie.mowziesmobs.server.world.BiomeChecker;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.FrostmawStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.UmvuthanaGroveStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.WroughtnautChamberStructure;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class ConfiguredFeatureHandler {
    public static Holder<Structure> CONFIGURED_WROUGHT_CHAMBER;
    public static Holder<Structure> CONFIGURED_UMVUTHANA_GROVE;
    public static Holder<Structure> CONFIGURED_FROSTMAW;
    public static Holder<Structure> CONFIGURED_MONASTERY;
    public static Holder<StructureSet> WROUGHT_CHAMBERS;
    public static Holder<StructureSet> UMVUTHANA_GROVES;
    public static Holder<StructureSet> FROSTMAWS;
    public static Holder<StructureSet> MONASTERIES;
    public static BiomeChecker FERROUS_WROUGHTNAUT_BIOME_CHECKER;
    public static final Set<Holder<Biome>> FERROUS_WROUGHTNAUT_BIOMES;
    public static BiomeChecker UMVUTHI_BIOME_CHECKER;
    public static final Set<Holder<Biome>> UMVUTHI_BIOMES;
    public static BiomeChecker FROSTMAW_BIOME_CHECKER;
    public static final Set<Holder<Biome>> FROSTMAW_BIOMES;
    public static BiomeChecker SCULPTOR_BIOME_CHECKER;
    public static final Set<Holder<Biome>> SCULPTOR_BIOMES;

    private static ResourceKey<Structure> createStructureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation("mowziesmobs", name));
    }

    private static ResourceKey<StructureSet> createSetKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)new ResourceLocation("mowziesmobs", name));
    }

    private static Holder<Structure> register(ResourceKey<Structure> key, Structure feature) {
        return BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_235988_, key, (Object)feature);
    }

    static Holder<StructureSet> register(ResourceKey<StructureSet> key, StructureSet set) {
        return BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_211084_, key, (Object)set);
    }

    static Holder<StructureSet> register(ResourceKey<StructureSet> key, Holder<Structure> configuredFeature, StructurePlacement placement) {
        return ConfiguredFeatureHandler.register(key, new StructureSet(configuredFeature, placement));
    }

    public static void registerConfiguredFeatures() {
        CONFIGURED_WROUGHT_CHAMBER = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createStructureKey("wrought_chamber"), new WroughtnautChamberStructure(ConfiguredFeatureHandler.structure(TagHandler.HAS_MOWZIE_STRUCTURE, TerrainAdjustment.NONE)));
        CONFIGURED_UMVUTHANA_GROVE = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createStructureKey("umvuthana_grove"), new UmvuthanaGroveStructure(ConfiguredFeatureHandler.structure(TagHandler.HAS_MOWZIE_STRUCTURE, TerrainAdjustment.NONE)));
        CONFIGURED_FROSTMAW = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createStructureKey("frostmaw_spawn"), new FrostmawStructure(ConfiguredFeatureHandler.structure(TagHandler.HAS_MOWZIE_STRUCTURE, TerrainAdjustment.BEARD_THIN)));
        WROUGHT_CHAMBERS = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createSetKey("wrought_chambers"), CONFIGURED_WROUGHT_CHAMBER, (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.TRIANGULAR, 23217347));
        UMVUTHANA_GROVES = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createSetKey("umvuthana_groves"), CONFIGURED_UMVUTHANA_GROVE, (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.TRIANGULAR, 23311138));
        FROSTMAWS = ConfiguredFeatureHandler.register(ConfiguredFeatureHandler.createSetKey("frostmaw_spawns"), CONFIGURED_FROSTMAW, (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.TRIANGULAR, 23317578));
    }

    private static HolderSet<Biome> biomes(TagKey<Biome> p_236537_) {
        return BuiltinRegistries.f_123865_.m_203561_(p_236537_);
    }

    private static Structure.StructureSettings structure(TagKey<Biome> p_236546_, Map<MobCategory, StructureSpawnOverride> p_236547_, GenerationStep.Decoration p_236548_, TerrainAdjustment p_236549_) {
        return new Structure.StructureSettings(ConfiguredFeatureHandler.biomes(p_236546_), p_236547_, p_236548_, p_236549_);
    }

    private static Structure.StructureSettings structure(TagKey<Biome> p_236543_, TerrainAdjustment p_236544_) {
        return ConfiguredFeatureHandler.structure(p_236543_, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, p_236544_);
    }

    public static void addBiomeSpawns(Holder<Biome> biomeKey) {
        if (FERROUS_WROUGHTNAUT_BIOME_CHECKER == null) {
            FERROUS_WROUGHTNAUT_BIOME_CHECKER = new BiomeChecker(ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.generationConfig.generationDistance.get() >= 0 && FERROUS_WROUGHTNAUT_BIOME_CHECKER.isBiomeInConfig(biomeKey)) {
            FERROUS_WROUGHTNAUT_BIOMES.add(biomeKey);
        }
        if (UMVUTHI_BIOME_CHECKER == null) {
            UMVUTHI_BIOME_CHECKER = new BiomeChecker(ConfigHandler.COMMON.MOBS.UMVUTHI.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.UMVUTHI.generationConfig.generationDistance.get() >= 0 && UMVUTHI_BIOME_CHECKER.isBiomeInConfig(biomeKey)) {
            UMVUTHI_BIOMES.add(biomeKey);
        }
        if (FROSTMAW_BIOME_CHECKER == null) {
            FROSTMAW_BIOME_CHECKER = new BiomeChecker(ConfigHandler.COMMON.MOBS.FROSTMAW.generationConfig.biomeConfig);
        }
        if ((Integer)ConfigHandler.COMMON.MOBS.FROSTMAW.generationConfig.generationDistance.get() >= 0 && FROSTMAW_BIOME_CHECKER.isBiomeInConfig(biomeKey)) {
            FROSTMAW_BIOMES.add(biomeKey);
        }
    }

    static {
        FERROUS_WROUGHTNAUT_BIOMES = new HashSet<Holder<Biome>>();
        UMVUTHI_BIOMES = new HashSet<Holder<Biome>>();
        FROSTMAW_BIOMES = new HashSet<Holder<Biome>>();
        SCULPTOR_BIOMES = new HashSet<Holder<Biome>>();
    }
}

