/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.mob;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MeleeAttackAbility<T extends MowzieGeckoEntity>
extends Ability<T> {
    protected SoundEvent attackSound;
    protected float knockBackMultiplier = 0.0f;
    protected float range;
    protected float damageMultiplier;
    protected SoundEvent hitSound;
    protected boolean hurtInterrupts;
    protected String[] animationNames;

    public MeleeAttackAbility(AbilityType<T, ? extends MeleeAttackAbility<T>> abilityType, T user, String[] animationNames, SoundEvent attackSound, SoundEvent hitSound, float knockBackMultiplier, float range, float damageMultiplier, int startup, int recovery, boolean hurtInterrupts) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, startup), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, recovery)}, 0);
        this.attackSound = attackSound;
        this.hitSound = hitSound;
        this.knockBackMultiplier = knockBackMultiplier;
        this.damageMultiplier = damageMultiplier;
        this.range = range;
        this.hurtInterrupts = hurtInterrupts;
        this.animationNames = animationNames;
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (((MowzieGeckoEntity)this.getUser()).m_5448_() != null) {
            ((MowzieGeckoEntity)this.getUser()).m_21391_((Entity)((MowzieGeckoEntity)this.getUser()).m_5448_(), 30.0f, 30.0f);
            ((MowzieGeckoEntity)this.getUser()).m_21563_().m_24960_((Entity)((MowzieGeckoEntity)this.getUser()).m_5448_(), 30.0f, 30.0f);
        }
        ((MowzieGeckoEntity)this.getUser()).m_21573_().m_26573_();
        ((MowzieGeckoEntity)this.getUser()).m_21566_().m_24988_(0.0f, 0.0f);
        ((MowzieGeckoEntity)this.getUser()).setStrafing(false);
    }

    @Override
    public void start() {
        super.start();
        String animationName = this.animationNames[((MowzieGeckoEntity)this.getUser()).m_217043_().m_188503_(this.animationNames.length)];
        this.playAnimation(animationName, false);
    }

    @Override
    protected void beginSection(AbilitySection section) {
        super.beginSection(section);
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            LivingEntity entityTarget = ((MowzieGeckoEntity)this.getUser()).m_5448_();
            if (entityTarget != null && ((MowzieGeckoEntity)this.getUser()).targetDistance <= this.range) {
                ((MowzieGeckoEntity)this.getUser()).doHurtTarget((Entity)entityTarget, this.damageMultiplier, this.knockBackMultiplier);
                this.onAttack(entityTarget, this.damageMultiplier, this.knockBackMultiplier);
                if (this.hitSound != null) {
                    ((MowzieGeckoEntity)this.getUser()).m_5496_(this.hitSound, 1.0f, 1.0f);
                }
            }
            if (this.attackSound != null) {
                ((MowzieGeckoEntity)this.getUser()).m_5496_(this.attackSound, 1.0f, 1.0f);
            }
        }
    }

    protected void onAttack(LivingEntity entityTarget, float damageMultiplier, float applyKnockbackMultiplier) {
    }

    @Override
    public boolean damageInterrupts() {
        return this.hurtInterrupts;
    }
}

