/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.util.IInventoryLink;
import com.tom.storagemod.util.MultiItemHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class RemoteConnections
extends SavedData {
    private static final String CONNECTIONS_TAG = "connections";
    public static final String CHANNEL_ID = "id";
    public static final String OWNER_ID = "owner";
    public static final String PUBLIC_TAG = "public";
    public static final String DISPLAY_NAME = "name";
    private static final String ID = "toms_storage_rc";
    private Map<UUID, Channel> connections = new HashMap<UUID, Channel>();

    private RemoteConnections() {
    }

    private RemoteConnections(CompoundTag tag) {
        RemoteConnections.load(tag.m_128437_(CONNECTIONS_TAG, 10), this.connections);
    }

    public static void load(ListTag list, Map<UUID, Channel> connections) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag t = list.m_128728_(i);
            UUID channel = t.m_128342_(CHANNEL_ID);
            connections.put(channel, new Channel(t));
        }
    }

    public static RemoteConnections get(Level world) {
        ServerLevel sw = (ServerLevel)world;
        return (RemoteConnections)sw.m_7654_().m_129783_().m_8895_().m_164861_(RemoteConnections::new, RemoteConnections::new, ID);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.connections.forEach((k, v) -> {
            CompoundTag t = new CompoundTag();
            t.m_128362_(CHANNEL_ID, k);
            v.save(t);
            list.add((Object)t);
        });
        tag.m_128365_(CONNECTIONS_TAG, (Tag)list);
        return tag;
    }

    public Channel getChannel(UUID connection) {
        return this.connections.get(connection);
    }

    public UUID makeChannel(CompoundTag t, UUID owner) {
        UUID id = UUID.randomUUID();
        Object name = t.m_128461_(DISPLAY_NAME);
        if (((String)name).length() > 50) {
            name = "Channel " + System.currentTimeMillis();
        }
        this.connections.put(id, new Channel(owner, t.m_128471_(PUBLIC_TAG), (String)name));
        this.m_77762_();
        return id;
    }

    public void removeChannel(UUID id, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            this.connections.remove(id);
            this.m_77762_();
        }
    }

    public ListTag listChannels(Player pl) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, Channel> e : this.connections.entrySet()) {
            if (!e.getValue().publicChannel && !e.getValue().owner.equals(pl.m_20148_())) continue;
            CompoundTag t = new CompoundTag();
            t.m_128362_(CHANNEL_ID, e.getKey());
            e.getValue().save(t);
            list.add((Object)t);
        }
        return list;
    }

    public void editChannel(UUID id, boolean pub, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            c.publicChannel = pub;
            this.m_77762_();
        }
    }

    public void invalidateCache(UUID id) {
        Channel c = this.connections.get(id);
        if (c != null) {
            c.connectors.clear();
        }
    }

    public static class Channel {
        public Set<DimPos> connectors = new HashSet<DimPos>();
        public UUID owner;
        public boolean publicChannel;
        public String displayName;

        public Channel(UUID owner, boolean publicChannel, String displayName) {
            this.owner = owner;
            this.publicChannel = publicChannel;
            this.displayName = displayName;
        }

        private Channel(CompoundTag t) {
            this(t.m_128342_(RemoteConnections.OWNER_ID), t.m_128471_(RemoteConnections.PUBLIC_TAG), t.m_128461_(RemoteConnections.DISPLAY_NAME));
        }

        public static Channel fromTag(CompoundTag t) {
            return new Channel(null, t.m_128471_(RemoteConnections.PUBLIC_TAG), t.m_128461_(RemoteConnections.DISPLAY_NAME));
        }

        public void register(ServerLevel world, BlockPos blockPos) {
            DimPos pos = new DimPos((Level)world, blockPos);
            this.connectors.add(pos);
        }

        public IItemHandler findOthers(ServerLevel world, BlockPos blockPos, int lvl) {
            DimPos pos = new DimPos((Level)world, blockPos);
            this.connectors.add(pos);
            Iterator<DimPos> posItr = this.connectors.iterator();
            MultiItemHandler handler = new MultiItemHandler();
            while (posItr.hasNext()) {
                DimPos dimPos = posItr.next();
                if (dimPos.equals(pos)) continue;
                BlockEntity te = dimPos.getTileEntity(world);
                if (te instanceof IInventoryLink) {
                    IInventoryLink link = (IInventoryLink)te;
                    LazyOptional<IItemHandler> h = link.getInventoryFrom((Level)world, lvl);
                    if (h == null) continue;
                    handler.add(h);
                    continue;
                }
                posItr.remove();
            }
            handler.refresh();
            return handler;
        }

        public void save(CompoundTag t) {
            t.m_128362_(RemoteConnections.OWNER_ID, this.owner);
            t.m_128379_(RemoteConnections.PUBLIC_TAG, this.publicChannel);
            t.m_128359_(RemoteConnections.DISPLAY_NAME, this.displayName);
        }

        public void saveNet(CompoundTag t) {
            t.m_128379_(RemoteConnections.PUBLIC_TAG, this.publicChannel);
            t.m_128359_(RemoteConnections.DISPLAY_NAME, this.displayName);
        }
    }

    public static class DimPos {
        public int x;
        public int y;
        public int z;
        public ResourceKey<Level> dim;

        public DimPos(Level world, BlockPos pos) {
            this.x = pos.m_123341_();
            this.y = pos.m_123342_();
            this.z = pos.m_123343_();
            this.dim = world.m_46472_();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dim == null ? 0 : this.dim.m_135782_().hashCode());
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DimPos other = (DimPos)obj;
            if (this.dim == null ? other.dim != null : !this.dim.equals(other.dim)) {
                return false;
            }
            if (this.x != other.x) {
                return false;
            }
            if (this.y != other.y) {
                return false;
            }
            return this.z == other.z;
        }

        public BlockEntity getTileEntity(ServerLevel world) {
            BlockPos pos;
            ServerLevel dim = world.m_7654_().m_129880_(this.dim);
            if (!dim.m_46749_(pos = new BlockPos(this.x, this.y, this.z))) {
                return null;
            }
            return dim.m_7702_(pos);
        }
    }
}

