/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.platform;

import com.tom.storagemod.Content;
import com.tom.storagemod.model.BakedPaintedModel;
import com.tom.storagemod.util.GameObject;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class PlatformModelLoader {
    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(PlatformModelLoader::bakeModels);
    }

    private static void bakeModels(ModelEvent.BakingCompleted event) {
        PlatformModelLoader.bindPaintedModel(event, Content.paintedTrim);
        PlatformModelLoader.bindPaintedModel(event, Content.invCableFramed);
        PlatformModelLoader.bindPaintedModel(event, Content.invProxy);
        PlatformModelLoader.bindPaintedModel(event, Content.invCableConnectorFramed);
    }

    private static void bindPaintedModel(ModelEvent.BakingCompleted event, GameObject<? extends Block> block) {
        ResourceLocation baseLoc = block.getId();
        block.get().m_49965_().m_61056_().forEach(st -> {
            ModelResourceLocation resLoc = BlockModelShaper.m_110889_((ResourceLocation)baseLoc, (BlockState)st);
            event.getModels().put(resLoc, new BakedPaintedModel((Block)block.get(), (BakedModel)event.getModels().get(resLoc)));
        });
    }
}

