/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.gui.CraftingTerminalScreen;
import com.tom.storagemod.gui.InventoryConnectorFilterScreen;
import com.tom.storagemod.gui.InventoryLinkScreen;
import com.tom.storagemod.gui.ItemFilterScreen;
import com.tom.storagemod.gui.LevelEmitterScreen;
import com.tom.storagemod.gui.StorageTerminalScreen;
import com.tom.storagemod.gui.TagItemFilterScreen;
import com.tom.storagemod.item.WirelessTerminalItem;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.PlatformModelLoader;
import com.tom.storagemod.tile.PaintedBlockEntity;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class StorageModClient {
    public static KeyMapping openTerm;
    private static Component[] tooltipExt;

    public static void preInit() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(StorageModClient::registerColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(StorageModClient::initKeybinds);
        PlatformModelLoader.init();
    }

    public static void clientSetup() {
        MenuScreens.m_96206_(Content.storageTerminal.get(), StorageTerminalScreen::new);
        MenuScreens.m_96206_(Content.craftingTerminalCont.get(), CraftingTerminalScreen::new);
        MenuScreens.m_96206_(Content.invCableConnectorFilteredConatiner.get(), InventoryConnectorFilterScreen::new);
        MenuScreens.m_96206_(Content.levelEmitterConatiner.get(), LevelEmitterScreen::new);
        MenuScreens.m_96206_(Content.inventoryLink.get(), InventoryLinkScreen::new);
        MenuScreens.m_96206_(Content.itemFilterConatiner.get(), ItemFilterScreen::new);
        MenuScreens.m_96206_(Content.tagItemFilterConatiner.get(), TagItemFilterScreen::new);
        MinecraftForge.EVENT_BUS.register(StorageModClient.class);
    }

    public static void initKeybinds(RegisterKeyMappingsEvent evt) {
        openTerm = new KeyMapping("key.toms_storage.open_terminal", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.m_84895_(66), "key.categories.gameplay");
        evt.register(openTerm);
    }

    public static void registerColors(RegisterColorHandlersEvent.Block event) {
        event.register(StorageModClient::getColor, new Block[]{(Block)Content.paintedTrim.get(), (Block)Content.invCableFramed.get(), (Block)Content.invProxy.get(), (Block)Content.invCableConnectorFramed.get()});
    }

    private static int getColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        if (world != null) {
            try {
                BlockState mimicBlock = ((PaintedBlockEntity)world.m_7702_(pos)).getPaintedBlockState();
                return Minecraft.m_91087_().m_91298_().m_92577_(mimicBlock, world, pos, tintIndex);
            }
            catch (Exception var8) {
                return -1;
            }
        }
        return -1;
    }

    @SubscribeEvent
    public static void renderWorldOutline(RenderLevelStageEvent evt) {
        if (evt.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player == null) {
                return;
            }
            if (!WirelessTerminalItem.isPlayerHolding((Player)player)) {
                return;
            }
            BlockHitResult lookingAt = (BlockHitResult)player.m_19907_((double)Config.get().wirelessRange, 0.0f, true);
            BlockState state = mc.f_91073_.m_8055_(lookingAt.m_82425_());
            if (state.m_204336_(StorageTags.REMOTE_ACTIVATE)) {
                BlockPos pos = lookingAt.m_82425_();
                Vec3 renderPos = mc.f_91063_.m_109153_().m_90583_();
                PoseStack ms = evt.getPoseStack();
                VertexConsumer buf = mc.m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
                StorageModClient.drawShape(ms, buf, state.m_60768_((BlockGetter)player.f_19853_, pos), (double)pos.m_123341_() - renderPos.f_82479_, (double)pos.m_123342_() - renderPos.f_82480_, (double)pos.m_123343_() - renderPos.f_82481_, 1.0f, 1.0f, 1.0f, 0.4f);
                mc.m_91269_().m_110104_().m_109912_(RenderType.m_110504_());
            }
        }
    }

    private static void drawShape(PoseStack matrices, VertexConsumer vertexConsumer, VoxelShape voxelShape, double d, double e, double f, float g, float h, float i, float j) {
        PoseStack.Pose entry = matrices.m_85850_();
        voxelShape.m_83224_((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = Mth.m_14116_((float)(q * q + r * r + s * s));
            vertexConsumer.m_85982_(entry.m_85861_(), (float)(k + d), (float)(l + e), (float)(m + f)).m_85950_(g, h, i, j).m_85977_(entry.m_85864_(), q /= t, r /= t, s /= t).m_5752_();
            vertexConsumer.m_85982_(entry.m_85861_(), (float)(n + d), (float)(o + e), (float)(p + f)).m_85950_(g, h, i, j).m_85977_(entry.m_85864_(), q, r, s).m_5752_();
        });
    }

    public static void tooltip(String key, List<Component> tooltip, Object ... args) {
        StorageModClient.tooltip(key, true, tooltip, args);
    }

    public static void tooltip(String key, boolean addShift, List<Component> tooltip, Object ... args) {
        if (Screen.m_96638_()) {
            String[] sp = I18n.m_118938_((String)("tooltip.toms_storage." + key), (Object[])args).split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                tooltip.add((Component)Component.m_237113_((String)sp[i]));
            }
        } else if (addShift) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.toms_storage.hold_shift_for_info").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent evt) {
        if (Minecraft.m_91087_().f_91074_ == null || evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (openTerm.m_90859_()) {
            NetworkHandler.openTerminal();
        }
    }

    public static void setTooltip(Component ... string) {
        tooltipExt = string;
    }

    @SubscribeEvent
    public static void getTooltip(ItemTooltipEvent evt) {
        Collections.addAll(evt.getToolTip(), tooltipExt);
    }

    static {
        tooltipExt = new Component[0];
    }
}

