/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura_neb.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.ITeleportation;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.OtherworlderEntity;
import com.github.manasmods.tensura.entity.magic.lightning.BlackLightningBolt;
import com.github.manasmods.tensura.entity.magic.projectile.IceLanceProjectile;
import com.github.manasmods.tensura.entity.magic.skill.WaterBladeProjectile;
import com.github.manasmods.tensura.entity.projectile.WebBulletProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.ProjectileImpactEvent;

public class RimuruOgreFightEntity
extends OtherworlderEntity
implements ITeleportation {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(RimuruOgreFightEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int miscAnimationTicks = 0;
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_20).m_7005_(true);

    public RimuruOgreFightEntity(EntityType<? extends RimuruOgreFightEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 2000;
        this.f_19793_ = 2.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 50.0).m_22268_(Attributes.f_22276_, 4000.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 64.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal((HumanoidNPCEntity)this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new CrossbowAttackGoal((Mob)this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal((HumanoidNPCEntity)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RimuruAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this, new Class[]{RimuruOgreFightEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, arg_0 -> ((RimuruOgreFightEntity)this).shouldAttackPlayer(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> entity.m_6095_().m_204039_(TensuraTags.EntityTypes.OTHERWORLDER_PREY)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("MiscAnimation", this.getMiscAnimation());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)pCompound.m_128451_("MiscAnimation"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura_neb", "textures/entity/rimuru_ogre_fight.png");
    }

    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)UniqueSkills.PREDATOR.get(), (ManasSkill)UniqueSkills.GREAT_SAGE.get());
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public boolean m_6469_(DamageSource source, float pAmount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.shouldDodge(source)) {
            return false;
        }
        return super.m_6469_(source, pAmount);
    }

    public void onProjectileImpact(ProjectileImpactEvent event) {
        if (event.isCanceled()) {
            return;
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
        event.getProjectile().m_146870_();
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_, (double)2.0);
    }

    private boolean shouldDodge(DamageSource source) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (source.m_19378_()) {
                return false;
            }
            if (!DamageSourceHelper.isPhysicalAttack((DamageSource)source)) {
                return false;
            }
            if ((double)entity2.m_217043_().m_188501_() >= 0.2) {
                return false;
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 2.0f, 1.0f);
            if (!this.m_9236_().m_5776_() && this.m_5448_() != null) {
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
                this.teleportTowards((LivingEntity)this, (Entity)this.m_5448_(), 12.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
            }
            return true;
        }
        return false;
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (this.m_20202_() instanceof Boat || this.m_20202_() instanceof AbstractMinecart) {
            this.m_20202_().m_6469_(DamageSource.m_19370_((LivingEntity)this), 40.0f);
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 4) {
                breath = this.getSkill(this.f_19796_.m_188499_() ? (ManasSkill)IntrinsicSkills.POISONOUS_BREATH.get() : (ManasSkill)IntrinsicSkills.PARALYSING_BREATH.get());
                if (this.miscAnimationTicks >= 1 && breath != null) {
                    if (this.miscAnimationTicks == 1) {
                        breath.onPressed((LivingEntity)this);
                    } else if (this.m_5448_() != null || this.m_6688_() != null) {
                        breath.onHeld((LivingEntity)this, 0);
                    }
                    SkillAPI.getSkillsFrom((Entity)this).syncChanges();
                }
            } else if (this.getMiscAnimation() == 5) {
                breath = this.getSkill((ManasSkill)ExtraSkills.BLACK_FLAME.get());
                if (this.miscAnimationTicks >= 1 && breath != null) {
                    if (this.miscAnimationTicks == 1) {
                        breath.onPressed((LivingEntity)this);
                    } else if (this.m_5448_() != null || this.m_6688_() != null) {
                        breath.onHeld((LivingEntity)this, 0);
                    }
                    SkillAPI.getSkillsFrom((Entity)this).syncChanges();
                }
            }
            if (this.miscAnimationTicks >= 60) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
        if ((target = this.m_5448_()) == null) {
            return;
        }
        if (!this.m_6084_()) {
            return;
        }
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        if (target.m_20270_((Entity)this) <= 5.0f) {
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
            this.teleportTowards((LivingEntity)this, (Entity)target, 12.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
        } else if (target.m_20270_((Entity)this) >= 20.0f) {
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
            this.teleportTowards((LivingEntity)this, (Entity)target, 20.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
        }
    }

    private void bladeShoot() {
        if (this.m_5448_() != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_146892_());
        }
        this.m_21011_(InteractionHand.MAIN_HAND, true);
        WaterBladeProjectile blade = new WaterBladeProjectile(this.f_19853_, (LivingEntity)this);
        blade.setSpeed(5.0f);
        blade.setDamage((float)this.m_21133_(Attributes.f_22281_) * 2.0f);
        Vector3f vector3f = new Vector3f(this.m_20252_(1.0f));
        blade.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), 3.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)blade);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.NEUTRAL, 0.5f, 0.4f + (this.f_19796_.m_188501_() * 0.4f + 0.8f));
    }

    private void icicleShoot(int arrowAmount) {
        if (this.m_5448_() != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_146892_());
        }
        int arrowRot = 360 / arrowAmount;
        for (int i = 0; i < arrowAmount; ++i) {
            Vec3 arrowOffset = new Vec3(0.0, 1.0, 0.0).m_82535_(((float)(arrowRot * i) - (float)arrowRot / 2.0f) * ((float)Math.PI / 180));
            Vec3 arrowPos = this.m_146892_().m_82549_(this.m_20154_().m_82541_().m_82490_(1.0)).m_82549_(arrowOffset.m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180)));
            IceLanceProjectile blade = new IceLanceProjectile(this.m_9236_(), (LivingEntity)this);
            blade.setSpeed(3.0f);
            blade.setDamage((float)this.m_21133_(Attributes.f_22281_));
            blade.m_20242_(true);
            blade.m_146884_(arrowPos);
            Vector3f vector3f = new Vector3f(this.m_20252_(1.0f));
            blade.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), 3.0f, 0.0f);
            this.m_9236_().m_7967_((Entity)blade);
            this.f_19853_.m_6263_(null, arrowPos.m_7096_(), arrowPos.m_7098_(), arrowPos.m_7094_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private void blackLightning() {
        Vec3 pos;
        LivingEntity target = this.m_5448_();
        if (target != null) {
            pos = target.m_20182_();
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)this.f_19853_, (Entity)this, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)50.0);
            pos = result.m_82450_();
        }
        BlackLightningBolt bolt = new BlackLightningBolt(this.f_19853_, (Entity)this);
        int radius = 5;
        bolt.setTensuraDamage((float)this.m_21133_(Attributes.f_22281_) * 3.0f);
        bolt.setAdditionalVisual(6);
        bolt.setRadius((float)radius);
        bolt.setSkill(this.getSkill((ManasSkill)ExtraSkills.BLACK_LIGHTNING.get()));
        bolt.m_146884_(pos);
        this.f_19853_.m_7967_((Entity)bolt);
        this.m_21011_(InteractionHand.MAIN_HAND, true);
    }

    private void shootWebBullet() {
        WebBulletProjectile bullet = new WebBulletProjectile(this.f_19853_, (LivingEntity)this, true, ((Item)TensuraToolItems.STICKY_STEEL_WEB_CARTRIDGE.get()).m_7968_());
        Vector3f vector3f = new Vector3f(this.m_20252_(1.0f));
        bullet.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), 1.0f, 0.0f);
        this.m_6674_(this.m_7655_());
        this.f_19853_.m_7967_((Entity)bullet);
        this.m_21011_(InteractionHand.MAIN_HAND, true);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Nullable
    private ManasSkillInstance getSkill(ManasSkill manasSkill) {
        Optional skill = SkillAPI.getSkillsFrom((Entity)this).getSkill(manasSkill);
        if (skill.isEmpty()) {
            return null;
        }
        if (!((ManasSkillInstance)skill.get()).canInteractSkill((LivingEntity)this)) {
            return null;
        }
        return (ManasSkillInstance)skill.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_213945_(this.f_19796_, pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        ItemStack stack = new ItemStack((ItemLike)TensuraToolItems.ARMOURSAURUS_GAUNTLET.get());
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
        this.inventory.m_6836_(5, stack);
        this.inventory.m_6596_();
    }

    public class RimuruAttackGoal
    extends HumanoidNPCEntity.NPCMeleeAttackGoal {
        public final RimuruOgreFightEntity entity;

        public RimuruAttackGoal(RimuruOgreFightEntity entity) {
            super((HumanoidNPCEntity)RimuruOgreFightEntity.this, (PathfinderMob)entity, 2.0, true);
            this.entity = entity;
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            if (this.entity.getMiscAnimation() != 0) {
                return;
            }
            double d0 = this.m_6639_(pEnemy);
            int randomAttack = this.randomAttack(pEnemy, pDistToEnemySqr);
            if (randomAttack == 0) {
                return;
            }
            double d = randomAttack == 1 ? d0 : d0 + 900.0;
            if (pDistToEnemySqr <= d && this.m_25564_()) {
                this.m_25563_();
                switch (randomAttack) {
                    default: {
                        this.entity.m_7327_((Entity)pEnemy);
                        break;
                    }
                    case 2: {
                        this.entity.bladeShoot();
                        break;
                    }
                    case 3: {
                        this.entity.m_21573_().m_26573_();
                        this.entity.icicleShoot(7);
                        break;
                    }
                    case 4: {
                        this.entity.setMiscAnimation(4);
                        break;
                    }
                    case 5: {
                        this.entity.setMiscAnimation(5);
                        break;
                    }
                    case 6: {
                        this.entity.blackLightning();
                        break;
                    }
                    case 7: {
                        this.entity.shootWebBullet();
                    }
                }
            }
        }

        protected int randomAttack(LivingEntity target, double distSqr) {
            if (distSqr > this.m_6639_(target) || this.entity.f_19796_.m_188503_(7) == 1) {
                if (this.entity.f_19796_.m_188503_(10) == 1) {
                    return 6;
                }
                if ((double)this.entity.f_19796_.m_188501_() <= 0.3) {
                    return 3;
                }
                if ((double)this.entity.f_19796_.m_188501_() <= 0.3) {
                    return 7;
                }
                return 2;
            }
            if (distSqr <= 64.0) {
                if (this.entity.f_19796_.m_188503_(10) == 1) {
                    return 5;
                }
                if (this.entity.f_19796_.m_188503_(5) == 1) {
                    return 4;
                }
            }
            return 1;
        }
    }
}

